/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator;

import java.io.Serializable;
import java.util.logging.Logger;
import nz.ac.waikato.cms.locator.ClassTraversal;
import nz.ac.waikato.cms.locator.LoggingHelper;
import nz.ac.waikato.cms.locator.TraversalListener;

public abstract class AbstractClassTraversal
implements Serializable,
ClassTraversal {
    private static final long serialVersionUID = -2973185784363491578L;
    public static final String DEFAULT_PACKAGE = "DEFAULT";
    protected transient Logger m_Logger;

    public static String extractPackage(String classname) {
        if (classname.contains(".")) {
            return classname.substring(0, classname.lastIndexOf("."));
        }
        return DEFAULT_PACKAGE;
    }

    public static String cleanUp(String classname) {
        String result = classname;
        if (result.contains("/")) {
            result = result.replace("/", ".");
        }
        if (result.contains("\\")) {
            result = result.replace("\\", ".");
        }
        if (result.endsWith(".class")) {
            result = result.substring(0, result.length() - 6);
        }
        return result;
    }

    protected AbstractClassTraversal() {
        this.initialize();
    }

    protected void initialize() {
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = Logger.getLogger(this.getClass().getName());
            this.m_Logger.setLevel(LoggingHelper.getLevel(this.getClass()));
        }
        return this.m_Logger;
    }

    @Override
    public abstract void traverse(TraversalListener var1);
}

