/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator;

import java.lang.reflect.Array;
import java.util.List;

public class ClassUtils {
    public static Class getArrayClass(Class c) {
        if (c.getComponentType().isArray()) {
            return ClassUtils.getArrayClass(c.getComponentType());
        }
        return c.getComponentType();
    }

    public static int getArrayDimensions(Class array) {
        if (array.getComponentType().isArray()) {
            return 1 + ClassUtils.getArrayDimensions(array.getComponentType());
        }
        return 1;
    }

    public static int getArrayDimensions(Object array) {
        return ClassUtils.getArrayDimensions(array.getClass());
    }

    public static String arrayToString(Object array, boolean outputClass) {
        StringBuilder result = new StringBuilder();
        int dimensions = ClassUtils.getArrayDimensions(array);
        if (dimensions == 0) {
            result.append("null");
        } else if (dimensions == 1) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                if (Array.get(array, i) == null) {
                    result.append("null");
                    continue;
                }
                Object obj = Array.get(array, i);
                if (outputClass) {
                    if (obj instanceof Class) {
                        result.append(((Class)obj).getName());
                        continue;
                    }
                    result.append(obj.getClass().getName());
                    continue;
                }
                result.append(obj.toString());
            }
        } else {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append("[" + ClassUtils.arrayToString(Array.get(array, i)) + "]");
            }
        }
        return result.toString();
    }

    public static String arrayToString(Object array) {
        return ClassUtils.arrayToString(array, false);
    }

    public static String flatten(List lines, String sep) {
        return ClassUtils.flatten(lines.toArray(new Object[lines.size()]), sep);
    }

    public static String flatten(Object[] lines, String sep) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append(sep);
            }
            result.append(lines[i].toString());
        }
        return result.toString();
    }
}

