/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator.blacklisting;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import nz.ac.waikato.cms.locator.blacklisting.AbstractBlacklister;

public class SimpleBlacklister
extends AbstractBlacklister {
    protected Set<File> m_BlacklistedDirs;
    protected Set<String> m_BlacklistedFiles;
    protected Set<String> m_BlacklistedFilePatterns;
    protected transient List<Pattern> m_BlacklistedFilePatternsCompiled;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_BlacklistedDirs = new HashSet<File>();
        this.m_BlacklistedFiles = new HashSet<String>();
        this.m_BlacklistedFilePatterns = new HashSet<String>();
    }

    public void blacklistDir(File dir) {
        this.m_BlacklistedDirs.add(dir.getAbsoluteFile());
    }

    public File[] blacklistedDirs() {
        return this.m_BlacklistedDirs.toArray(new File[0]);
    }

    public void blacklistFile(String file) {
        this.m_BlacklistedFiles.add(file);
    }

    public String[] blacklistedFiles() {
        return this.m_BlacklistedFiles.toArray(new String[0]);
    }

    public void blacklistFilePattern(String pattern) {
        this.m_BlacklistedFilePatterns.add(pattern);
        this.m_BlacklistedFilePatternsCompiled = null;
    }

    public String[] blacklistedFilePatterns() {
        return this.m_BlacklistedFilePatterns.toArray(new String[0]);
    }

    @Override
    public boolean isBlacklistedDir(File dir) {
        return this.m_BlacklistedDirs.contains(dir.getAbsoluteFile());
    }

    @Override
    public synchronized boolean isBlacklistedFile(File file) {
        String name = file.getName();
        boolean result = this.m_BlacklistedFiles.contains(name);
        if (!result) {
            if (this.m_BlacklistedFilePatternsCompiled == null) {
                this.m_BlacklistedFilePatternsCompiled = new ArrayList<Pattern>();
                for (String string : this.m_BlacklistedFilePatterns) {
                    try {
                        this.m_BlacklistedFilePatternsCompiled.add(Pattern.compile(string));
                    }
                    catch (Exception e) {
                        System.err.println(this.getClass().getName() + ": Failed to compile file pattern '" + string + "'!");
                        e.printStackTrace();
                    }
                }
            }
            for (Pattern pattern : this.m_BlacklistedFilePatternsCompiled) {
                if (!pattern.matcher(name).matches()) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

