/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import nz.ac.waikato.cms.locator.ClassPathTraversal;
import nz.ac.waikato.cms.locator.LoggingHelper;

public class ClassCache
implements Serializable {
    private static final long serialVersionUID = -2973185784363491578L;
    protected transient Logger m_Logger;
    protected HashMap<String, HashSet<String>> m_NameCache;
    protected HashMap<String, HashSet<Class>> m_ClassCache;

    public ClassCache() {
        this.initialize();
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = Logger.getLogger(this.getClass().getName());
            this.m_Logger.setLevel(LoggingHelper.getLevel(this.getClass()));
        }
        return this.m_Logger;
    }

    public boolean remove(String classname) {
        String pkgname = ClassPathTraversal.extractPackage(classname = ClassPathTraversal.cleanUp(classname));
        HashSet<String> names = this.m_NameCache.get(pkgname);
        if (names != null) {
            return names.remove(classname);
        }
        return false;
    }

    public Iterator<String> packages() {
        return this.m_NameCache.keySet().iterator();
    }

    public HashSet<String> getClassnames(String pkgname) {
        if (this.m_NameCache.containsKey(pkgname)) {
            return this.m_NameCache.get(pkgname);
        }
        return new HashSet<String>();
    }

    public HashSet<Class> getClasses(String pkgname) {
        if (this.m_ClassCache.containsKey(pkgname)) {
            return this.m_ClassCache.get(pkgname);
        }
        return new HashSet<Class>();
    }

    protected void initialize() {
        ClassPathTraversal traversal = new ClassPathTraversal();
        Listener listener = new Listener();
        traversal.traverse(listener);
        this.m_NameCache = listener.getNameCache();
        this.m_ClassCache = listener.getClassCache();
    }

    public static void main(String[] args) {
        ClassCache cache = new ClassCache();
        Iterator<String> packages = cache.packages();
        ArrayList<String> sorted = new ArrayList<String>();
        while (packages.hasNext()) {
            sorted.add(packages.next());
        }
        Collections.sort(sorted);
        for (String key : sorted) {
            System.out.println(key + ": " + cache.getClassnames(key).size());
        }
    }

    public static class Listener
    implements ClassPathTraversal.TraversalListener {
        protected HashMap<String, HashSet<String>> m_NameCache = new HashMap();
        protected HashMap<String, HashSet<Class>> m_ClassCache = new HashMap();

        @Override
        public void traversing(String classname, URL classPathPart) {
            String pkgname = ClassPathTraversal.extractPackage(classname);
            if (!this.m_NameCache.containsKey(pkgname)) {
                this.m_NameCache.put(pkgname, new HashSet());
            }
            if (!this.m_ClassCache.containsKey(pkgname)) {
                this.m_ClassCache.put(pkgname, new HashSet());
            }
            HashSet<String> names = this.m_NameCache.get(pkgname);
            names.add(classname);
        }

        public HashMap<String, HashSet<String>> getNameCache() {
            return this.m_NameCache;
        }

        public HashMap<String, HashSet<Class>> getClassCache() {
            return this.m_ClassCache;
        }
    }
}

