/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import nz.ac.waikato.cms.locator.ClassLocator;
import nz.ac.waikato.cms.locator.ClassUtils;
import nz.ac.waikato.cms.locator.LoggingHelper;

public class ClassLister
implements Serializable {
    private static final long serialVersionUID = 8482163084925911272L;
    protected transient Logger m_Logger;
    protected Properties m_Packages = ClassLister.load("nz/ac/waikato/cms/locator/ClassLister.props");
    protected HashMap<String, HashSet<String>> m_CacheNames;
    protected HashMap<String, List<String>> m_ListNames;
    protected HashMap<String, HashSet<Class>> m_CacheClasses;
    protected HashMap<String, List<Class>> m_ListClasses;
    protected Properties m_Blacklist = ClassLister.load("nz/ac/waikato/cms/locator/ClassLister.blacklist");
    protected boolean m_OnlyDefaultConstructor;
    protected static ClassLister m_Singleton;

    protected ClassLister() {
    }

    public static Properties load(String props) {
        return ClassLister.load(props, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(String props, Properties defProps) {
        Properties result = new Properties(defProps);
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream(props);
            result.load(is);
        }
        catch (Exception e) {
            result = defProps;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = Logger.getLogger(this.getClass().getName());
            this.m_Logger.setLevel(LoggingHelper.getLevel(this.getClass()));
        }
        return this.m_Logger;
    }

    public void setOnlyDefaultConstructor(boolean value) {
        this.m_OnlyDefaultConstructor = value;
    }

    public boolean isOnlyDefaultConstructor() {
        return this.m_OnlyDefaultConstructor;
    }

    public void setPackages(Properties value) {
        this.m_Packages = value;
    }

    public void setBlacklist(Properties value) {
        this.m_Blacklist = value;
    }

    protected void updateClassnames(HashMap<String, HashSet<String>> cache, String superclass, HashSet<String> names) {
        if (!cache.containsKey(superclass)) {
            cache.put(superclass, names);
        } else {
            cache.get(superclass).addAll(names);
        }
    }

    protected void updateClassnames(HashMap<String, List<String>> list, String superclass, List<String> names) {
        if (!list.containsKey(superclass)) {
            list.put(superclass, names);
        } else {
            for (String name : names) {
                if (list.get(superclass).contains(name)) continue;
                list.get(superclass).add(name);
            }
        }
    }

    protected void updateClasses(HashMap<String, HashSet<Class>> cache, String superclass, HashSet<Class> names) {
        if (!cache.containsKey(superclass)) {
            cache.put(superclass, names);
        } else {
            cache.get(superclass).addAll(names);
        }
    }

    protected void updateClasses(HashMap<String, List<Class>> list, String superclass, List<Class> classes) {
        if (!list.containsKey(superclass)) {
            list.put(superclass, classes);
        } else {
            for (Class cls : classes) {
                if (list.get(superclass).contains(cls)) continue;
                list.get(superclass).add(cls);
            }
        }
    }

    protected ClassLocator getClassLocator() {
        ClassLocator result = ClassLocator.getSingleton();
        if (result.isOnlyDefaultConstructor() != this.isOnlyDefaultConstructor()) {
            result.setOnlyDefaultConstructor(this.isOnlyDefaultConstructor());
        }
        return result;
    }

    public void addHierarchy(String superclass, String[] packages) {
        ClassLocator locator = this.getClassLocator();
        List<String> names = locator.findNames(superclass, packages);
        List<Class> classes = locator.findClasses(superclass, packages);
        if (this.m_Blacklist.containsKey(superclass)) {
            try {
                String[] patterns;
                for (String pattern : patterns = this.m_Blacklist.getProperty(superclass).replaceAll(" ", "").split(",")) {
                    Pattern p = Pattern.compile(pattern);
                    int i = 0;
                    while (i < names.size()) {
                        if (p.matcher(names.get(i)).matches()) {
                            names.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < classes.size()) {
                        if (p.matcher(classes.get(i).getName()).matches()) {
                            classes.remove(i);
                            continue;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, "Failed to blacklist classes for superclass '" + superclass + "':", ex);
            }
        }
        this.updateClassnames(this.m_CacheNames, superclass, new HashSet<String>(names));
        this.updateClassnames(this.m_ListNames, superclass, new ArrayList<String>(names));
        this.updateClasses(this.m_CacheClasses, superclass, new HashSet<Class>(classes));
        this.updateClasses(this.m_ListClasses, superclass, new ArrayList<Class>(classes));
    }

    public void initialize() {
        try {
            this.m_CacheNames = new HashMap();
            this.m_ListNames = new HashMap();
            this.m_CacheClasses = new HashMap();
            this.m_ListClasses = new HashMap();
            Enumeration<?> enm = this.m_Packages.propertyNames();
            while (enm.hasMoreElements()) {
                String superclass = (String)enm.nextElement();
                String[] packages = this.m_Packages.getProperty(superclass).replaceAll(" ", "").split(",");
                this.addHierarchy(superclass, packages);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to determine packages/classes:", e);
            this.m_Packages = new Properties();
        }
    }

    public String[] getClassnames(Class superclass) {
        List<String> list = this.m_ListNames.get(superclass.getName());
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }

    public Class[] getClasses(Class superclass) {
        return this.getClasses(superclass.getName());
    }

    public Class[] getClasses(String superclass) {
        List<Class> list = this.m_ListClasses.get(superclass);
        if (list == null) {
            return new Class[0];
        }
        return list.toArray(new Class[list.size()]);
    }

    public String[] getSuperclasses(Class cls) {
        return this.getSuperclasses(cls.getName());
    }

    public String[] getSuperclasses(String cls) {
        ArrayList<String> result = new ArrayList<String>();
        for (String superclass : this.m_CacheNames.keySet()) {
            if (!this.m_CacheNames.get(superclass).contains(cls)) continue;
            result.add(superclass);
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getSuperclasses() {
        ArrayList<String> result = new ArrayList<String>(this.m_CacheNames.keySet());
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public String[] getPackages(Class superclass) {
        return this.getPackages(superclass.getName());
    }

    public String[] getPackages(String superclass) {
        String packages = this.m_Packages.getProperty(superclass);
        if (packages == null || packages.length() == 0) {
            return new String[0];
        }
        return packages.split(",");
    }

    public Properties getPackages() {
        return this.m_Packages;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(this.m_ListNames.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            result.append(key).append("\n");
            result.append(ClassUtils.flatten(this.m_ListNames.get(key), ",")).append("\n\n");
        }
        return result.toString();
    }

    public static synchronized ClassLister getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ClassLister();
        }
        return m_Singleton;
    }
}

