/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import nz.ac.waikato.cms.locator.LoggingHelper;

public class ClassPathTraversal
implements Serializable {
    private static final long serialVersionUID = -2973185784363491578L;
    public static final String DEFAULT_PACKAGE = "DEFAULT";
    protected transient Logger m_Logger;

    public static String extractPackage(String classname) {
        if (classname.contains(".")) {
            return classname.substring(0, classname.lastIndexOf("."));
        }
        return DEFAULT_PACKAGE;
    }

    public static String cleanUp(String classname) {
        String result = classname;
        if (result.contains("/")) {
            result = result.replace("/", ".");
        }
        if (result.contains("\\")) {
            result = result.replace("\\", ".");
        }
        if (result.endsWith(".class")) {
            result = result.substring(0, result.length() - 6);
        }
        return result;
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = Logger.getLogger(this.getClass().getName());
            this.m_Logger.setLevel(LoggingHelper.getLevel(this.getClass()));
        }
        return this.m_Logger;
    }

    public void traverse(String classname, TraversalState state) {
        classname = ClassPathTraversal.cleanUp(classname);
        state.getListener().traversing(classname, state.getURL());
    }

    protected void traverseDir(String prefix, File dir, TraversalState state) {
        File[] files;
        for (File file : files = dir.listFiles(new ClassFileFilter())) {
            if (prefix == null) {
                this.traverse(file.getName(), state);
                continue;
            }
            this.traverse(prefix + "." + file.getName(), state);
        }
        for (File file : files = dir.listFiles(new DirectoryFilter())) {
            if (prefix == null) {
                this.traverseDir(file.getName(), file, state);
                continue;
            }
            this.traverseDir(prefix + "." + file.getName(), file, state);
        }
    }

    protected void traverseDir(File dir, TraversalState state) {
        if (this.isLoggingEnabled()) {
            this.getLogger().log(Level.INFO, "Analyzing directory: " + dir);
        }
        this.traverseDir(null, dir, state);
    }

    protected void traverseManifest(Manifest manifest, TraversalState state) {
        String[] parts;
        if (manifest == null) {
            return;
        }
        Attributes atts = manifest.getMainAttributes();
        String cp = atts.getValue("Class-Path");
        if (cp == null) {
            return;
        }
        for (String part : parts = cp.split(" ")) {
            if (part.trim().length() == 0) {
                return;
            }
            if (!part.toLowerCase().endsWith(".jar") && part.equals(".")) continue;
            this.traverseClasspathPart(part, state);
        }
    }

    protected void traverseJar(File file, TraversalState state) {
        if (this.isLoggingEnabled()) {
            this.getLogger().log(Level.INFO, "Analyzing jar: " + file);
        }
        if (!file.exists()) {
            this.getLogger().log(Level.WARNING, "Jar does not exist: " + file);
            return;
        }
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> enm = jar.entries();
            while (enm.hasMoreElements()) {
                JarEntry entry = enm.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                this.traverse(entry.getName(), state);
            }
            this.traverseManifest(jar.getManifest(), state);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to inspect: " + file, e);
        }
    }

    protected void traverseClasspathPart(String part, TraversalState state) {
        File file = null;
        if (part.startsWith("file:")) {
            part = part.replace(" ", "%20");
            try {
                file = new File(new URI(part));
            }
            catch (URISyntaxException e) {
                this.getLogger().log(Level.SEVERE, "Failed to generate URI: " + part, e);
            }
        } else {
            file = new File(part);
        }
        if (file == null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().log(Level.INFO, "Skipping: " + part);
            }
            return;
        }
        if (file.isDirectory()) {
            this.traverseDir(file, state);
        } else if (file.exists()) {
            this.traverseJar(file, state);
        }
    }

    public void traverse(TraversalListener listener) {
        URL[] urls;
        TraversalState state = new TraversalState(listener);
        URLClassLoader sysLoader = (URLClassLoader)this.getClass().getClassLoader();
        for (URL url : urls = sysLoader.getURLs()) {
            state.setURL(url);
            if (this.isLoggingEnabled()) {
                this.getLogger().log(Level.INFO, "Classpath URL: " + url);
            }
            String part = url.toString();
            this.traverseClasspathPart(part, state);
        }
    }

    public static class TraversalState {
        protected URL m_URL = null;
        protected TraversalListener m_Listener;

        public TraversalState(TraversalListener listener) {
            this.m_Listener = listener;
        }

        public void setURL(URL value) {
            this.m_URL = value;
        }

        public URL getURL() {
            return this.m_URL;
        }

        public TraversalListener getListener() {
            return this.m_Listener;
        }
    }

    public static interface TraversalListener {
        public void traversing(String var1, URL var2);
    }

    public static class DirectoryFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    public static class ClassFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".class");
        }
    }
}

