/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.jenericcmdline;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import nz.ac.waikato.cms.jenericcmdline.Processor;
import nz.ac.waikato.cms.jenericcmdline.core.JCClassLister;
import nz.ac.waikato.cms.jenericcmdline.handlers.AbstractHandler;
import nz.ac.waikato.cms.jenericcmdline.handlers.Handler;
import nz.ac.waikato.cms.jenericcmdline.traversal.All;
import nz.ac.waikato.cms.jenericcmdline.traversal.Traverser;
import nz.ac.waikato.cms.locator.LoggingHelper;

public abstract class AbstractProcessor
implements Serializable,
Processor {
    protected Logger m_Logger;
    protected Map<Class, Handler> m_Cache;
    protected Handler[] m_Handlers;
    protected Traverser m_Traverser;

    protected AbstractProcessor() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Cache = new HashMap<Class, Handler>();
        Class[] classes = AbstractHandler.getHandlers();
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        for (Class cls : classes) {
            try {
                handlers.add((Handler)cls.newInstance());
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to instantiate handler: " + cls.getName(), e);
            }
        }
        this.m_Handlers = handlers.toArray(new Handler[handlers.size()]);
        this.m_Traverser = new All();
    }

    protected Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = Logger.getLogger(this.getClass().getName());
            this.m_Logger.setLevel(LoggingHelper.getLevel(this.getClass()));
        }
        return this.m_Logger;
    }

    public void setTraverser(Traverser value) {
        this.m_Traverser = value;
    }

    public Traverser getTraverser() {
        return this.m_Traverser;
    }

    public Handler getHandler(Object obj) {
        return this.getHandler(obj.getClass());
    }

    public Handler getHandler(Class cls) {
        if (this.m_Cache.containsKey(cls)) {
            this.getLogger().info("Cached: " + cls.getName() + " -> " + this.m_Cache.get(cls).getClass().getName());
            return this.m_Cache.get(cls);
        }
        Handler result = null;
        for (Handler handler : this.m_Handlers) {
            if (!handler.handles(cls)) continue;
            result = handler;
            this.getLogger().info("Found handler: " + cls.getName() + " -> " + handler.getClass().getName());
            this.m_Cache.put(cls, handler);
            break;
        }
        return result;
    }

    public static Class[] getProcessors() {
        return JCClassLister.getSingleton().getClasses(Processor.class);
    }
}

