/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.jenericcmdline;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import nz.ac.waikato.cms.jenericcmdline.AbstractProcessor;
import nz.ac.waikato.cms.jenericcmdline.core.IntrospectionContainer;
import nz.ac.waikato.cms.jenericcmdline.core.IntrospectionHelper;
import nz.ac.waikato.cms.jenericcmdline.core.OptionUtils;
import nz.ac.waikato.cms.jenericcmdline.example.Nested;
import nz.ac.waikato.cms.jenericcmdline.example.Simple;
import nz.ac.waikato.cms.jenericcmdline.handlers.Handler;
import nz.ac.waikato.cms.jenericcmdline.traversal.All;

public class DefaultProcessor
extends AbstractProcessor {
    public static final String ARRAY_PREFIX = "array-";

    @Override
    public String toCommandline(Object obj) throws Exception {
        String result = obj.getClass().getName();
        String[] options = this.getOptions(obj);
        if (options.length > 0) {
            result = result + " " + OptionUtils.joinOptions(options);
        }
        return result;
    }

    @Override
    public Object fromCommandline(String s) throws Exception {
        if (s.trim().length() == 0) {
            throw new IllegalArgumentException("No commandline provided!");
        }
        String[] parts = OptionUtils.splitOptions(s);
        if (parts.length == 0) {
            throw new IllegalArgumentException("Could not split commandline: '" + s + "'");
        }
        Object result = Class.forName(parts[0]).newInstance();
        String[] options = new String[parts.length - 1];
        System.arraycopy(parts, 1, options, 0, options.length);
        this.setOptions(result, options);
        return result;
    }

    @Override
    public String[] getOptions(Object obj) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        IntrospectionContainer cont = IntrospectionHelper.introspect(obj.getClass());
        for (PropertyDescriptor desc : cont.properties) {
            int i;
            Object value;
            Class<?> cls = desc.getReadMethod().getReturnType();
            String name = desc.getDisplayName();
            String flag = OptionUtils.displayNameToFlag(name);
            boolean array = cls.isArray();
            Class<?> base = array ? cls.getComponentType() : cls;
            Handler handler = this.getHandler(base);
            if (handler == null) {
                this.getLogger().fine("No handler found for: " + name + "/" + base.getName() + (array ? "[]" : ""));
                if (!this.m_Traverser.canTraverse(cls, base)) {
                    this.getLogger().fine("Traversal not possible: " + name + "/" + base.getName() + (array ? "[]" : ""));
                    continue;
                }
                value = desc.getReadMethod().invoke(obj, new Object[0]);
                if (value == null) continue;
                if (array) {
                    for (i = 0; i < Array.getLength(value); ++i) {
                        result.add("-array-" + flag);
                        result.add(this.toCommandline(Array.get(value, i)));
                    }
                    continue;
                }
                result.add("-" + flag);
                result.add(this.toCommandline(value));
                continue;
            }
            value = desc.getReadMethod().invoke(obj, new Object[0]);
            if (value == null) continue;
            if (array) {
                for (i = 0; i < Array.getLength(value); ++i) {
                    result.add("-array-" + flag);
                    result.add(handler.toString(Array.get(value, i)));
                }
                continue;
            }
            result.add("-" + flag);
            result.add(handler.toString(value));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(Object obj, String[] options) throws Exception {
        IntrospectionContainer cont = IntrospectionHelper.introspect(obj.getClass());
        for (PropertyDescriptor desc : cont.properties) {
            Object value;
            Class<?> cls = desc.getReadMethod().getReturnType();
            String name = desc.getDisplayName();
            String flag = OptionUtils.displayNameToFlag(name);
            boolean array = cls.isArray();
            Class<?> base = array ? cls.getComponentType() : cls;
            ArrayList<String> values = new ArrayList<String>();
            int i = -2;
            String search = array ? "-array-" + flag : "-" + flag;
            while (i < options.length - 2) {
                if (!options[i += 2].equals(search)) continue;
                options[i] = "";
                if (i >= options.length - 1) continue;
                values.add(options[i + 1]);
                options[i + 1] = "";
            }
            Handler handler = this.getHandler(base);
            if (handler == null) {
                this.getLogger().fine("No handler found for: " + name + "/" + base.getName() + (array ? "[]" : ""));
                if (!this.m_Traverser.canTraverse(cls, base)) {
                    this.getLogger().fine("Traversal not possible: " + name + "/" + base.getName() + (array ? "[]" : ""));
                    continue;
                }
                if (array) {
                    value = Array.newInstance(base, values.size());
                    for (i = 0; i < values.size(); ++i) {
                        Array.set(value, i, this.fromCommandline((String)values.get(i)));
                    }
                    desc.getWriteMethod().invoke(obj, value);
                    continue;
                }
                if (values.size() <= 0) continue;
                value = this.fromCommandline((String)values.get(0));
                desc.getWriteMethod().invoke(obj, value);
                continue;
            }
            if (array) {
                value = Array.newInstance(base, values.size());
                for (i = 0; i < values.size(); ++i) {
                    Array.set(value, i, handler.fromString(base, (String)values.get(i)));
                }
                desc.getWriteMethod().invoke(obj, value);
                continue;
            }
            if (values.size() <= 0) continue;
            value = handler.fromString(base, (String)values.get(0));
            desc.getWriteMethod().invoke(obj, value);
        }
    }

    public static void main(String[] args) throws Exception {
        Simple simple = new Simple();
        simple.setTruth(true);
        simple.setEightBit((byte)7);
        simple.setSixteenBit((short)42);
        simple.setThirtyTwoBit(314);
        simple.setSixtyFourBit(31415L);
        simple.setFloatie(0.123f);
        simple.setQuadrupleHalf(123.456);
        simple.setMoreThanOneTruth(new boolean[]{true, false, true});
        simple.setManyInts(new int[]{1, 2, 3});
        simple.setSomeDoubles(new double[]{0.1, 0.2, 0.3});
        simple.setOneTwoThree(Simple.OneTwoThree.THREE);
        simple.setMany(new Simple.OneTwoThree[]{Simple.OneTwoThree.ONE, Simple.OneTwoThree.TWO});
        Simple simple2 = new Simple();
        simple2.setTruth(false);
        simple2.setEightBit((byte)1);
        simple2.setFloatie(1.234f);
        Nested nested = new Nested();
        nested.setSimple(simple);
        nested.setSimpleArray(new Simple[]{new Simple(), simple2});
        nested.setFloating(0.456);
        nested.setIntegral(1234);
        DefaultProcessor processor = new DefaultProcessor();
        processor.setTraverser(new All());
        System.out.println("\nSimple");
        String cmdline = processor.toCommandline(simple);
        System.out.println("-initial commandline:\n" + cmdline);
        Simple simpleNew = (Simple)processor.fromCommandline(cmdline);
        cmdline = processor.toCommandline(simpleNew);
        System.out.println("-to and from commandline:\n" + cmdline);
        System.out.println("\nNested");
        cmdline = processor.toCommandline(nested);
        System.out.println("-initial commandline:\n" + cmdline);
        Nested nestedNew = (Nested)processor.fromCommandline(cmdline);
        cmdline = processor.toCommandline(nestedNew);
        System.out.println("-to and from commandline:\n" + cmdline);
    }
}

