/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.ijava;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.spencerpark.ijava.JavaKernel;
import io.github.spencerpark.jupyter.channels.JupyterConnection;
import io.github.spencerpark.jupyter.channels.JupyterSocket;
import io.github.spencerpark.jupyter.kernel.KernelConnectionProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;

public class IJava {
    public static final String COMPILER_OPTS_KEY = "IJAVA_COMPILER_OPTS";
    public static final String TIMEOUT_DURATION_KEY = "IJAVA_TIMEOUT";
    public static final String CLASSPATH_KEY = "IJAVA_CLASSPATH";
    public static final String STARTUP_SCRIPTS_KEY = "IJAVA_STARTUP_SCRIPTS_PATH";
    public static final String STARTUP_SCRIPT_KEY = "IJAVA_STARTUP_SCRIPT";
    public static final String DEFAULT_SHELL_INIT_RESOURCE_PATH = "ijava-jshell-init.jshell";
    public static final String VERSION;
    private static JavaKernel kernel;

    public static InputStream resource(String path) {
        return IJava.class.getClassLoader().getResourceAsStream(path);
    }

    public static JavaKernel getKernelInstance() {
        return kernel;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("Missing connection file argument");
        }
        Path connectionFile = Paths.get(args[0], new String[0]);
        if (!Files.isRegularFile(connectionFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Connection file '" + connectionFile + "' isn't a file.");
        }
        String contents = new String(Files.readAllBytes(connectionFile));
        JupyterSocket.JUPYTER_LOGGER.setLevel(Level.WARNING);
        KernelConnectionProperties connProps = KernelConnectionProperties.parse(contents);
        JupyterConnection connection = new JupyterConnection(connProps);
        kernel = new JavaKernel();
        kernel.becomeHandlerForConnection(connection);
        connection.connect();
        connection.waitUntilClose();
        kernel = null;
        System.exit(0);
    }

    static {
        InputStream metaStream = IJava.resource("ijava-kernel-metadata.json");
        InputStreamReader metaReader = new InputStreamReader(metaStream);
        try {
            JsonElement meta = new JsonParser().parse(metaReader);
            VERSION = meta.getAsJsonObject().get("version").getAsString();
        }
        finally {
            try {
                ((Reader)metaReader).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        kernel = null;
    }
}

