/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.ijava.execution;

import io.github.spencerpark.ijava.JavaKernel;
import io.github.spencerpark.ijava.execution.CompilationException;
import io.github.spencerpark.ijava.execution.EvaluationInterruptedException;
import io.github.spencerpark.ijava.execution.EvaluationTimeoutException;
import io.github.spencerpark.ijava.execution.IJavaExecutionControl;
import io.github.spencerpark.ijava.execution.IJavaExecutionControlProvider;
import io.github.spencerpark.ijava.execution.IncompleteSourceException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jshell.EvalException;
import jdk.jshell.JShell;
import jdk.jshell.JShellException;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;

public class CodeEvaluator {
    private static final Pattern WHITESPACE_PREFIX = Pattern.compile("(?:^|\r?\n)(?<ws>\\s*).*$");
    private static final Pattern LAST_LINE = Pattern.compile("(?:^|\r?\n)(?<last>.*)$");
    private static final String NO_MAGIC_RETURN = "\"__NO_MAGIC_RETURN\"";
    private final JShell shell;
    private final IJavaExecutionControlProvider executionControlProvider;
    private final String executionControlID;
    private final SourceCodeAnalysis sourceAnalyzer;
    private boolean isInitialized = false;
    private final List<String> startupScripts;
    private final String indentation = "  ";

    public CodeEvaluator(JShell shell, IJavaExecutionControlProvider executionControlProvider, String executionControlID, List<String> startupScripts) {
        this.shell = shell;
        this.executionControlProvider = executionControlProvider;
        this.executionControlID = executionControlID;
        this.sourceAnalyzer = this.shell.sourceCodeAnalysis();
        this.startupScripts = startupScripts;
    }

    public JShell getShell() {
        return this.shell;
    }

    private SourceCodeAnalysis.CompletionInfo analyzeCompletion(String source) {
        return this.sourceAnalyzer.analyzeCompletion(source);
    }

    private void init() throws Exception {
        for (String script : this.startupScripts) {
            this.eval(script);
        }
        this.startupScripts.clear();
    }

    protected Object evalSingle(String code) throws Exception {
        IJavaExecutionControl executionControl = this.executionControlProvider.getRegisteredControlByID(this.executionControlID);
        List<SnippetEvent> events = this.shell.eval(code);
        Object result = null;
        block11: for (SnippetEvent event : events) {
            String key = event.value();
            if (key == null) continue;
            Snippet.SubKind subKind = event.snippet().subKind();
            Object value = subKind.isExecutable() ? executionControl.takeResult(key) : event.value();
            switch (subKind) {
                case VAR_VALUE_SUBKIND: 
                case OTHER_EXPRESSION_SUBKIND: 
                case TEMP_VAR_EXPRESSION_SUBKIND: {
                    result = NO_MAGIC_RETURN.equals(value) ? null : value;
                    continue block11;
                }
            }
            result = null;
        }
        for (SnippetEvent event : events) {
            if (event.causeSnippet() != null) continue;
            JShellException e = event.exception();
            if (e != null) {
                if (e instanceof EvalException) {
                    switch (((EvalException)e).getExceptionClassName()) {
                        case "Execution Timeout": {
                            throw new EvaluationTimeoutException(executionControl.getTimeoutDuration(), executionControl.getTimeoutUnit(), code.trim());
                        }
                        case "Execution Interrupted": {
                            throw new EvaluationInterruptedException(code.trim());
                        }
                    }
                    throw e;
                }
                throw e;
            }
            if (event.status().isDefined()) continue;
            throw new CompilationException(event);
        }
        return result;
    }

    public Object eval(String code) throws Exception {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.init();
        }
        Object lastEvalResult = null;
        SourceCodeAnalysis.CompletionInfo info = this.sourceAnalyzer.analyzeCompletion(code);
        while (info.completeness().isComplete()) {
            lastEvalResult = this.evalSingle(info.source());
            info = this.analyzeCompletion(info.remaining());
        }
        if (info.completeness() != SourceCodeAnalysis.Completeness.EMPTY) {
            throw new IncompleteSourceException(info.remaining().trim());
        }
        return lastEvalResult;
    }

    private String computeIndentation(String partialStatement) {
        Matcher m = WHITESPACE_PREFIX.matcher(partialStatement);
        String currentIndentation = m.find() ? m.group("ws") : "";
        m = LAST_LINE.matcher(partialStatement);
        if (!m.find()) {
            throw new Error("Pattern broken. Every string should have a last line.");
        }
        String lastLine = m.group("last");
        int newlyOpenedBraces = -1;
        int newlyOpenedParens = -1;
        block6: for (int i = 0; i < lastLine.length(); ++i) {
            switch (lastLine.charAt(i)) {
                case '}': {
                    if (newlyOpenedBraces == -1) continue block6;
                    --newlyOpenedBraces;
                    continue block6;
                }
                case ')': {
                    if (newlyOpenedParens == -1) continue block6;
                    --newlyOpenedParens;
                    continue block6;
                }
                case '{': {
                    if (newlyOpenedBraces == -1) {
                        ++newlyOpenedBraces;
                    }
                    ++newlyOpenedBraces;
                    continue block6;
                }
                case '(': {
                    if (newlyOpenedParens == -1) {
                        ++newlyOpenedParens;
                    }
                    ++newlyOpenedParens;
                }
            }
        }
        return newlyOpenedBraces > 0 || newlyOpenedParens > 0 ? currentIndentation + this.indentation : currentIndentation;
    }

    public String isComplete(String code) {
        SourceCodeAnalysis.CompletionInfo info = this.sourceAnalyzer.analyzeCompletion(code);
        while (info.completeness().isComplete()) {
            info = this.analyzeCompletion(info.remaining());
        }
        switch (info.completeness()) {
            case UNKNOWN: {
                return JavaKernel.invalidCodeSignifier();
            }
            case COMPLETE: 
            case COMPLETE_WITH_SEMI: 
            case EMPTY: {
                return JavaKernel.completeCodeSignifier();
            }
            case CONSIDERED_INCOMPLETE: 
            case DEFINITELY_INCOMPLETE: {
                return this.computeIndentation(info.remaining());
            }
        }
        return JavaKernel.maybeCompleteCodeSignifier();
    }

    public void interrupt() {
        IJavaExecutionControl executionControl = this.executionControlProvider.getRegisteredControlByID(this.executionControlID);
        if (executionControl != null) {
            executionControl.interrupt();
        }
    }

    public void shutdown() {
        this.shell.close();
    }
}

