/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.ijava.execution;

import io.github.spencerpark.ijava.execution.CodeEvaluator;
import io.github.spencerpark.ijava.execution.IJavaExecutionControlProvider;
import io.github.spencerpark.ijava.execution.LazyInputStreamDelegate;
import io.github.spencerpark.ijava.execution.LazyOutputStreamDelegate;
import io.github.spencerpark.jupyter.kernel.util.GlobFinder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import jdk.jshell.JShell;

public class CodeEvaluatorBuilder {
    private static final Pattern PATH_SPLITTER = Pattern.compile(File.pathSeparator, 16);
    private static final Pattern BLANK = Pattern.compile("^\\s*$");
    private static final int BUFFER_SIZE = 1024;
    private static final OutputStream STDOUT = new LazyOutputStreamDelegate(() -> System.out);
    private static final OutputStream STDERR = new LazyOutputStreamDelegate(() -> System.err);
    private static final InputStream STDIN = new LazyInputStreamDelegate(() -> System.in);
    private String timeout;
    private final List<String> classpath = new LinkedList<String>();
    private final List<String> compilerOpts = new LinkedList<String>();
    private PrintStream out;
    private PrintStream err;
    private InputStream in;
    private List<String> startupScripts = new LinkedList<String>();

    public CodeEvaluatorBuilder addClasspathFromString(String classpath) {
        if (classpath == null) {
            return this;
        }
        if (BLANK.matcher(classpath).matches()) {
            return this;
        }
        Collections.addAll(this.classpath, PATH_SPLITTER.split(classpath));
        return this;
    }

    public CodeEvaluatorBuilder timeoutFromString(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public CodeEvaluatorBuilder timeout(long timeout, TimeUnit timeoutUnit) {
        return this.timeoutFromString(String.format("%d %s", timeout, timeoutUnit.name()));
    }

    public CodeEvaluatorBuilder compilerOptsFromString(String opts) {
        if (opts == null) {
            return this;
        }
        this.compilerOpts.addAll(CodeEvaluatorBuilder.split(opts));
        return this;
    }

    public CodeEvaluatorBuilder compilerOpts(String ... opts) {
        Collections.addAll(this.compilerOpts, opts);
        return this;
    }

    public CodeEvaluatorBuilder stdout(PrintStream out) {
        this.out = out;
        return this;
    }

    public CodeEvaluatorBuilder stderr(PrintStream err) {
        this.err = err;
        return this;
    }

    public CodeEvaluatorBuilder stdin(InputStream in) {
        this.in = in;
        return this;
    }

    public CodeEvaluatorBuilder sysStdout() {
        return this.stdout(new PrintStream(STDOUT));
    }

    public CodeEvaluatorBuilder sysStderr() {
        return this.stderr(new PrintStream(STDERR));
    }

    public CodeEvaluatorBuilder sysStdin() {
        return this.stdin(STDIN);
    }

    public CodeEvaluatorBuilder startupScript(String script) {
        if (script == null) {
            return this;
        }
        this.startupScripts.add(script);
        return this;
    }

    public CodeEvaluatorBuilder startupScript(InputStream scriptStream) {
        if (scriptStream == null) {
            return this;
        }
        try {
            int read;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = scriptStream.read(buffer)) != -1) {
                result.write(buffer, 0, read);
            }
            String script = result.toString(StandardCharsets.UTF_8.name());
            this.startupScripts.add(script);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("IOException while reading startup script from stream: %s", e.getMessage()), e);
        }
        finally {
            try {
                scriptStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public CodeEvaluatorBuilder startupScriptFiles(String paths) {
        if (paths == null) {
            return this;
        }
        if (BLANK.matcher(paths).matches()) {
            return this;
        }
        for (String glob : PATH_SPLITTER.split(paths)) {
            GlobFinder resolver = new GlobFinder(glob);
            try {
                for (Path path : resolver.computeMatchingPaths()) {
                    this.startupScriptFile(path);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("IOException while computing startup scripts for '%s': %s", glob, e.getMessage()), e);
            }
        }
        return this;
    }

    public CodeEvaluatorBuilder startupScriptFile(Path path) {
        if (path == null) {
            return this;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return this;
        }
        if (!Files.isReadable(path)) {
            return this;
        }
        try {
            String script = new String(Files.readAllBytes(path), "UTF-8");
            this.startupScripts.add(script);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("IOException while loading startup script for '%s': %s", path, e.getMessage()), e);
        }
        return this;
    }

    public CodeEvaluator build() {
        IJavaExecutionControlProvider executionControlProvider = new IJavaExecutionControlProvider();
        String executionControlID = UUID.randomUUID().toString();
        LinkedHashMap<String, String> executionControlParams = new LinkedHashMap<String, String>();
        executionControlParams.put("registration-id", executionControlID);
        if (this.timeout != null) {
            executionControlParams.put("timeout", this.timeout);
        }
        JShell.Builder builder = JShell.builder();
        if (this.out != null) {
            builder.out(this.out);
        }
        if (this.err != null) {
            builder.err(this.err);
        }
        if (this.in != null) {
            builder.in(this.in);
        }
        JShell shell = builder.executionEngine(executionControlProvider, executionControlParams).compilerOptions(this.compilerOpts.toArray(new String[0])).build();
        for (String cp : this.classpath) {
            if (BLANK.matcher(cp).matches()) continue;
            GlobFinder resolver = new GlobFinder(cp);
            try {
                for (Path entry : resolver.computeMatchingPaths()) {
                    shell.addToClasspath(entry.toAbsolutePath().toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("IOException while computing classpath entries for '%s': %s", cp, e.getMessage()), e);
            }
        }
        return new CodeEvaluator(shell, executionControlProvider, executionControlID, this.startupScripts);
    }

    private static List<String> split(String opts) {
        opts = opts.trim();
        LinkedList<String> split = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        boolean escape = false;
        block5: for (char c : opts.toCharArray()) {
            switch (c) {
                case '\t': 
                case ' ': {
                    if (inQuotes) {
                        current.append(c);
                        continue block5;
                    }
                    if (current.length() <= 0) continue block5;
                    split.add(current.toString());
                    current.setLength(0);
                    continue block5;
                }
                case '\\': {
                    if (escape) {
                        current.append("\\\\");
                        escape = false;
                        continue block5;
                    }
                    escape = true;
                    continue block5;
                }
                case '\"': {
                    if (escape) {
                        current.append('\"');
                        escape = false;
                        continue block5;
                    }
                    if (current.length() > 0 && inQuotes) {
                        split.add(current.toString());
                        current.setLength(0);
                        inQuotes = false;
                        continue block5;
                    }
                    inQuotes = true;
                    continue block5;
                }
                default: {
                    current.append(c);
                }
            }
        }
        if (current.length() > 0) {
            split.add(current.toString());
        }
        return split;
    }
}

