/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.channels;

import io.github.spencerpark.jupyter.channels.JupyterSocket;
import io.github.spencerpark.jupyter.channels.Loop;
import io.github.spencerpark.jupyter.kernel.KernelConnectionProperties;
import io.github.spencerpark.jupyter.messages.HMACGenerator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;

public class HeartbeatChannel
extends JupyterSocket {
    private static final long HB_DEFAULT_SLEEP_MS = 500L;
    private static final AtomicInteger HEARTBEAT_ID = new AtomicInteger();
    private final long sleep;
    private volatile Loop pulse;

    public HeartbeatChannel(ZMQ.Context context, HMACGenerator hmacGenerator, long sleep) {
        super(context, SocketType.REP, hmacGenerator, Logger.getLogger("HeartbeatChannel"));
        this.sleep = sleep;
    }

    public HeartbeatChannel(ZMQ.Context context, HMACGenerator hmacGenerator) {
        this(context, hmacGenerator, 500L);
    }

    private boolean isBound() {
        return this.pulse != null;
    }

    @Override
    public void bind(KernelConnectionProperties connProps) {
        if (this.isBound()) {
            throw new IllegalStateException("Heartbeat channel already bound");
        }
        String channelThreadName = "Heartbeat-" + HEARTBEAT_ID.getAndIncrement();
        String addr = JupyterSocket.formatAddress(connProps.getTransport(), connProps.getIp(), connProps.getHbPort());
        this.logger.log(Level.INFO, String.format("Binding %s to %s.", channelThreadName, addr));
        super.bind(addr);
        ZMQ.Poller poller = this.ctx.poller(1);
        poller.register(this, 1);
        this.pulse = new Loop(channelThreadName, this.sleep, () -> {
            int events = poller.poll(0L);
            if (events > 0) {
                byte[] msg = this.recv();
                if (msg == null) {
                    this.logger.log(Level.SEVERE, "Poll returned 1 event but could not read the echo string");
                    return;
                }
                if (!this.send(msg)) {
                    this.logger.log(Level.SEVERE, "Could not send heartbeat reply");
                }
                this.logger.log(Level.FINEST, "Heartbeat pulse");
            }
        });
        this.pulse.onClose(() -> {
            this.logger.log(Level.INFO, channelThreadName + " shutdown.");
            this.pulse = null;
        });
        this.pulse.start();
        this.logger.log(Level.INFO, "Polling on " + channelThreadName);
    }

    @Override
    public void close() {
        if (this.isBound()) {
            this.pulse.shutdown();
        }
        super.close();
    }

    @Override
    public void waitUntilClose() {
        if (this.pulse != null) {
            try {
                this.pulse.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

