/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.channels;

import io.github.spencerpark.jupyter.channels.HeartbeatChannel;
import io.github.spencerpark.jupyter.channels.IOPubChannel;
import io.github.spencerpark.jupyter.channels.JupyterSocket;
import io.github.spencerpark.jupyter.channels.ShellChannel;
import io.github.spencerpark.jupyter.channels.ShellHandler;
import io.github.spencerpark.jupyter.channels.ShellReplyEnvironment;
import io.github.spencerpark.jupyter.channels.StdinChannel;
import io.github.spencerpark.jupyter.kernel.KernelConnectionProperties;
import io.github.spencerpark.jupyter.messages.HMACGenerator;
import io.github.spencerpark.jupyter.messages.Message;
import io.github.spencerpark.jupyter.messages.MessageContext;
import io.github.spencerpark.jupyter.messages.MessageType;
import io.github.spencerpark.jupyter.messages.publish.PublishStatus;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.zeromq.ZMQ;

public class JupyterConnection {
    private final KernelConnectionProperties connProps;
    private boolean isConnected = false;
    private final ZMQ.Context ctx;
    protected final HeartbeatChannel heartbeat;
    protected final ShellChannel shell;
    protected final ShellChannel control;
    protected final StdinChannel stdin;
    protected final IOPubChannel iopub;
    private final Map<MessageType, ShellHandler> handlers;

    public JupyterConnection(KernelConnectionProperties connProps) throws NoSuchAlgorithmException, InvalidKeyException {
        this.connProps = connProps;
        this.ctx = ZMQ.context(1);
        HMACGenerator hmacGenerator = connProps.createHMACGenerator();
        this.heartbeat = new HeartbeatChannel(this.ctx, hmacGenerator);
        this.shell = new ShellChannel(this.ctx, hmacGenerator, false, this);
        this.control = new ShellChannel(this.ctx, hmacGenerator, true, this);
        this.stdin = new StdinChannel(this.ctx, hmacGenerator);
        this.iopub = new IOPubChannel(this.ctx, hmacGenerator);
        this.handlers = new HashMap<MessageType, ShellHandler>();
    }

    public void connect() {
        if (!this.isConnected) {
            this.forEachSocket(s -> s.bind(this.connProps));
            PublishStatus publishStatus = PublishStatus.STARTING;
            this.getIOPub().sendMessage(new Message<PublishStatus>(null, PublishStatus.MESSAGE_TYPE, publishStatus));
            this.isConnected = true;
        }
    }

    public IOPubChannel getIOPub() {
        return this.iopub;
    }

    public <T> void setHandler(MessageType<T> type, ShellHandler<T> handler) {
        this.handlers.put(type, handler);
    }

    public <T> ShellHandler<T> getHandler(MessageType<T> type) {
        return this.handlers.get(type);
    }

    public ShellReplyEnvironment prepareReplyEnv(ShellChannel shell, MessageContext context) {
        return new ShellReplyEnvironment(shell, this.stdin, this.iopub, context);
    }

    private void forEachSocket(Consumer<JupyterSocket> consumer) {
        consumer.accept(this.heartbeat);
        consumer.accept(this.shell);
        consumer.accept(this.control);
        consumer.accept(this.stdin);
        consumer.accept(this.iopub);
    }

    public void close() {
        this.forEachSocket(JupyterSocket::close);
        this.ctx.close();
    }

    public void waitUntilClose() {
        this.forEachSocket(JupyterSocket::waitUntilClose);
    }
}

