/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.channels;

import io.github.spencerpark.jupyter.channels.JupyterSocket;
import io.github.spencerpark.jupyter.channels.ShellReplyEnvironment;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;

public class JupyterInputStream
extends InputStream {
    private final Charset encoding;
    private ShellReplyEnvironment env;
    private boolean enabled;
    private byte[] data = null;
    private int bufferPos = 0;

    public JupyterInputStream(Charset encoding, ShellReplyEnvironment env, boolean enabled) {
        this.encoding = encoding;
        this.env = env;
        this.enabled = enabled;
    }

    public JupyterInputStream(Charset encoding) {
        this(encoding, null, false);
    }

    public JupyterInputStream(ShellReplyEnvironment env, boolean enabled) {
        this(JupyterSocket.UTF_8, env, enabled);
    }

    public void setEnv(ShellReplyEnvironment env) {
        this.env = env;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void retractEnv(ShellReplyEnvironment env) {
        if (this.env == env) {
            this.env = null;
        }
    }

    public boolean isAttached() {
        return this.env != null;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private byte[] readFromFrontend() {
        if (this.enabled) {
            return this.env.readFromStdIn().getBytes(this.encoding);
        }
        return new byte[0];
    }

    @Override
    public synchronized int read() {
        if (this.data == null) {
            if (this.env != null) {
                this.data = this.readFromFrontend();
                this.bufferPos = 0;
            } else {
                return -1;
            }
        }
        if (this.bufferPos >= this.data.length) {
            this.data = null;
            if (this.env != null && this.enabled) {
                this.data = this.readFromFrontend();
                this.bufferPos = 0;
            } else {
                return -1;
            }
        }
        return this.data[this.bufferPos++];
    }

    @Override
    public int read(byte[] into, int intoOffset, int len) {
        Objects.requireNonNull(into, "Target buffer cannot be null");
        if (intoOffset < 0) {
            throw new IndexOutOfBoundsException("intoOffset must be >= 0 but was " + intoOffset);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len must be >= 0 but was " + len);
        }
        if (len > into.length - intoOffset) {
            throw new IndexOutOfBoundsException(String.format("Reading len (%d) bytes starting at %d would overflow the buffer.", len, intoOffset));
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        into[intoOffset] = (byte)c;
        int available = this.available();
        if (available <= 0) {
            return 1;
        }
        int amountToTakeFromBuffer = Math.min(available, len);
        System.arraycopy(this.data, this.bufferPos, into, intoOffset + 1, amountToTakeFromBuffer);
        this.bufferPos += amountToTakeFromBuffer;
        return amountToTakeFromBuffer + 1;
    }

    @Override
    public int available() {
        return (this.data != null ? this.data.length : 0) - this.bufferPos;
    }
}

