/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.channels;

import io.github.spencerpark.jupyter.channels.JupyterSocket;
import io.github.spencerpark.jupyter.channels.ShellReplyEnvironment;
import java.io.ByteArrayOutputStream;
import java.util.function.BiConsumer;

public class JupyterOutputStream
extends ByteArrayOutputStream {
    private static final int INITIAL_BUFFER_CAP = 1024;
    private ShellReplyEnvironment env;
    private final BiConsumer<ShellReplyEnvironment, String> write;

    public JupyterOutputStream(ShellReplyEnvironment env, BiConsumer<ShellReplyEnvironment, String> write) {
        super(1024);
        this.env = env;
        this.write = write;
    }

    public JupyterOutputStream(BiConsumer<ShellReplyEnvironment, String> write) {
        this(null, write);
    }

    public void setEnv(ShellReplyEnvironment env) {
        this.env = env;
    }

    public void retractEnv(ShellReplyEnvironment env) {
        if (this.env == env) {
            this.env = null;
        }
    }

    public boolean isAttached() {
        return this.env != null;
    }

    @Override
    public void flush() {
        String contents;
        if (this.env != null && !(contents = new String(this.buf, 0, this.count, JupyterSocket.UTF_8)).isEmpty()) {
            this.write.accept(this.env, contents);
        }
        super.reset();
    }
}

