/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.channels;

import io.github.spencerpark.jupyter.channels.JupyterSocket;
import io.github.spencerpark.jupyter.kernel.KernelConnectionProperties;
import io.github.spencerpark.jupyter.messages.HMACGenerator;
import io.github.spencerpark.jupyter.messages.Message;
import io.github.spencerpark.jupyter.messages.MessageContext;
import io.github.spencerpark.jupyter.messages.reply.InputReply;
import io.github.spencerpark.jupyter.messages.request.InputRequest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;

public class StdinChannel
extends JupyterSocket {
    public StdinChannel(ZMQ.Context context, HMACGenerator hmacGenerator) {
        super(context, SocketType.ROUTER, hmacGenerator, Logger.getLogger("StdinChannel"));
    }

    @Override
    public void bind(KernelConnectionProperties connProps) {
        String addr = JupyterSocket.formatAddress(connProps.getTransport(), connProps.getIp(), connProps.getStdinPort());
        this.logger.log(Level.INFO, String.format("Binding stdin to %s.", addr));
        super.bind(addr);
    }

    public synchronized String getInput(MessageContext context, String prompt, boolean isPasswordRequest) {
        InputRequest content = new InputRequest(prompt, isPasswordRequest);
        Message<InputRequest> request = new Message<InputRequest>(context, InputRequest.MESSAGE_TYPE, content);
        super.sendMessage(request);
        Message<InputReply> reply = super.readMessage(InputReply.MESSAGE_TYPE);
        return reply.getContent().getValue() + System.lineSeparator();
    }
}

