/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.kernel;

import io.github.spencerpark.jupyter.channels.JupyterInputStream;
import io.github.spencerpark.jupyter.channels.JupyterOutputStream;
import io.github.spencerpark.jupyter.channels.JupyterSocket;
import io.github.spencerpark.jupyter.channels.ShellReplyEnvironment;
import io.github.spencerpark.jupyter.kernel.DisplayStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class JupyterIO {
    private final JupyterOutputStream jupyterOut = new JupyterOutputStream(ShellReplyEnvironment::writeToStdOut);
    private final JupyterOutputStream jupyterErr = new JupyterOutputStream(ShellReplyEnvironment::writeToStdErr);
    private final JupyterInputStream jupyterIn;
    public final DisplayStream display;
    public final PrintStream out;
    public final PrintStream err;
    public final InputStream in;

    public JupyterIO(Charset encoding) {
        this.jupyterIn = new JupyterInputStream(encoding);
        this.display = new DisplayStream();
        try {
            this.out = new PrintStream((OutputStream)this.jupyterOut, true, encoding.name());
            this.err = new PrintStream((OutputStream)this.jupyterErr, true, encoding.name());
            this.in = this.jupyterIn;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Couldn't lookup the charset by name even though it is already a charset...", e);
        }
    }

    public JupyterIO() {
        this(JupyterSocket.UTF_8);
    }

    public boolean isAttached() {
        return this.jupyterOut.isAttached() && this.jupyterErr.isAttached() && this.jupyterIn.isAttached() && this.display.isAttached();
    }

    protected void setEnv(ShellReplyEnvironment env) {
        this.jupyterOut.setEnv(env);
        this.jupyterErr.setEnv(env);
        this.jupyterIn.setEnv(env);
        this.display.setEnv(env);
    }

    protected void retractEnv(ShellReplyEnvironment env) {
        this.jupyterOut.retractEnv(env);
        this.jupyterErr.retractEnv(env);
        this.jupyterIn.retractEnv(env);
        this.display.retractEnv(env);
    }

    protected void setJupyterInEnabled(boolean enabled) {
        this.jupyterIn.setEnabled(enabled);
    }
}

