/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.kernel;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import io.github.spencerpark.jupyter.messages.HMACGenerator;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class KernelConnectionProperties {
    private String ip;
    @SerializedName(value="control_port")
    private int controlPort;
    @SerializedName(value="shell_port")
    private int shellPort;
    @SerializedName(value="stdin_port")
    private int stdinPort;
    @SerializedName(value="hb_port")
    private int hbPort;
    @SerializedName(value="iopub_port")
    private int iopubPort;
    private String transport;
    @SerializedName(value="signature_scheme")
    private String signatureScheme;
    private String key;

    public static KernelConnectionProperties parse(String raw) {
        return new Gson().fromJson(raw, KernelConnectionProperties.class);
    }

    private KernelConnectionProperties() {
    }

    public KernelConnectionProperties(String ip, int controlPort, int shellPort, int stdinPort, int hbPort, int iopubPort, String transport, String signatureScheme, String key) {
        this.ip = ip;
        this.controlPort = controlPort;
        this.shellPort = shellPort;
        this.stdinPort = stdinPort;
        this.hbPort = hbPort;
        this.iopubPort = iopubPort;
        this.transport = transport;
        this.signatureScheme = signatureScheme;
        this.key = key;
    }

    public String getIp() {
        return this.ip;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public int getShellPort() {
        return this.shellPort;
    }

    public int getStdinPort() {
        return this.stdinPort;
    }

    public int getHbPort() {
        return this.hbPort;
    }

    public int getIopubPort() {
        return this.iopubPort;
    }

    public String getTransport() {
        return this.transport;
    }

    public String getSignatureScheme() {
        return this.signatureScheme;
    }

    public String getKey() {
        return this.key;
    }

    public HMACGenerator createHMACGenerator() throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.key == null || this.key.isEmpty()) {
            return HMACGenerator.NO_AUTH_INSTANCE;
        }
        return new HMACGenerator(this.signatureScheme, this.key);
    }

    public String toJsonString() {
        return new Gson().toJson(this);
    }

    public String toString() {
        return "KernelConnectionProperties{ip='" + this.ip + '\'' + ", controlPort=" + this.controlPort + ", shellPort=" + this.shellPort + ", stdinPort=" + this.stdinPort + ", hbPort=" + this.hbPort + ", iopubPort=" + this.iopubPort + ", transport='" + this.transport + '\'' + ", signatureScheme='" + this.signatureScheme + '\'' + ", key='" + this.key + '\'' + '}';
    }
}

