/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.kernel.comm;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.spencerpark.jupyter.kernel.comm.CommManager;
import io.github.spencerpark.jupyter.messages.Message;
import io.github.spencerpark.jupyter.messages.comm.CommCloseCommand;
import io.github.spencerpark.jupyter.messages.comm.CommMsgCommand;
import java.util.List;
import java.util.Map;

public abstract class Comm {
    private final CommManager manager;
    private final String id;
    private final String targetName;
    private boolean closed = false;

    public Comm(CommManager manager, String id, String targetName) {
        this(manager, id, targetName, null);
    }

    public Comm(CommManager manager, String id, String targetName, JsonElement initializationData) {
        this.manager = manager;
        this.id = id;
        this.targetName = targetName;
    }

    public String getID() {
        return this.id;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void send(JsonObject data) {
        this.manager.messageComm(this.getID(), data);
    }

    public void send(JsonObject data, Map<String, Object> metadata, List<byte[]> blobs) {
        this.manager.messageComm(this.getID(), data, metadata, blobs);
    }

    protected abstract void onMessage(Message<CommMsgCommand> var1);

    protected abstract void onClose(Message<CommCloseCommand> var1, boolean var2);

    public final void close() {
        if (this.closed) {
            return;
        }
        this.manager.closeComm(this);
        this.closed = true;
    }
}

