/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.kernel.display;

import io.github.spencerpark.jupyter.kernel.display.DisplayData;
import io.github.spencerpark.jupyter.kernel.display.MIMESuffixAssociation;
import io.github.spencerpark.jupyter.kernel.display.mime.MIMEType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RenderRequestTypes {
    private final MIMESuffixAssociation suffixAssociation;
    private final boolean requestsWildcard;
    private final Set<String> entireGroupRequests;
    private final Set<MIMEType> requestedTypes;
    private final Map<String, List<MIMEType>> requestedTypesByGroup;

    private RenderRequestTypes(MIMESuffixAssociation suffixAssociation, boolean requestsWildcard, Set<String> entireGroupRequests, Set<MIMEType> requestedTypes) {
        this.suffixAssociation = suffixAssociation;
        this.requestsWildcard = requestsWildcard;
        this.entireGroupRequests = entireGroupRequests;
        this.requestedTypes = requestedTypes;
        this.requestedTypesByGroup = new LinkedHashMap<String, List<MIMEType>>();
        requestedTypes.forEach(t -> this.requestedTypesByGroup.compute(t.getGroup(), (k, v) -> {
            List l = v == null ? new LinkedList() : v;
            l.add(t);
            return l;
        }));
    }

    public MIMEType resolveSupportedType(MIMEType supportedType) {
        if (supportedType.isWildcard() || supportedType.subtypeIsWildcard()) {
            throw new IllegalArgumentException("Cannot resolve type of wildcard MIME type: '" + supportedType.toString() + "'");
        }
        if (this.requestsWildcard) {
            return supportedType;
        }
        if (this.requestedTypes.contains(supportedType) || this.entireGroupRequests.contains(supportedType.getGroup())) {
            return supportedType;
        }
        if (supportedType.hasSuffix()) {
            MIMEType withoutSuffix = supportedType.withoutSuffix();
            if (this.requestedTypes.contains(withoutSuffix)) {
                return withoutSuffix;
            }
            MIMEType suffixDelegate = this.suffixAssociation.resolveSuffix(supportedType.getSuffix());
            if (suffixDelegate != null && (this.requestedTypes.contains(suffixDelegate) || this.entireGroupRequests.contains(suffixDelegate.getGroup()))) {
                return suffixDelegate;
            }
        }
        return null;
    }

    public boolean isRequestedExactly(MIMEType type) {
        return this.requestsWildcard || this.entireGroupRequests.contains(type.getGroup()) || this.requestedTypes.contains(type);
    }

    public void removeFulfilledRequests(DisplayData out) {
        this.requestedTypes.removeIf(t -> {
            if (out.hasDataForType((MIMEType)t)) {
                this.requestedTypesByGroup.compute(t.getGroup(), (k, v) -> {
                    if (v == null) {
                        return null;
                    }
                    v.remove(t);
                    return v.isEmpty() ? null : v;
                });
                return true;
            }
            return false;
        });
    }

    public boolean anyRequestedIsSupported(Set<MIMEType> supported) {
        if (this.requestsWildcard) {
            return !supported.isEmpty();
        }
        for (MIMEType t : supported) {
            if (t.isWildcard() && !this.isEmpty()) {
                return true;
            }
            if (t.subtypeIsWildcard() && (this.entireGroupRequests.contains(t.getGroup()) || this.requestedTypesByGroup.containsKey(t.getGroup()))) {
                return true;
            }
            if (this.resolveSupportedType(t) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return !this.requestsWildcard && this.entireGroupRequests.isEmpty() && this.requestedTypes.isEmpty();
    }

    public static class Builder {
        private final MIMESuffixAssociation suffixAssociation;
        private boolean requestsWildcard;
        private final Set<String> entireGroupRequests;
        private final Set<MIMEType> requestedTypes;

        public Builder(MIMESuffixAssociation suffixAssociation) {
            this.suffixAssociation = suffixAssociation;
            this.requestsWildcard = false;
            this.entireGroupRequests = new LinkedHashSet<String>();
            this.requestedTypes = new LinkedHashSet<MIMEType>();
        }

        public Builder withType(String type) {
            MIMEType mimeType = MIMEType.parse(type);
            return this.withType(mimeType);
        }

        public Builder withType(MIMEType type) {
            if (type.isWildcard()) {
                this.requestsWildcard = true;
            } else if (!type.hasSubtype() || type.subtypeIsWildcard()) {
                this.entireGroupRequests.add(type.getGroup());
            } else {
                this.requestedTypes.add(type);
            }
            return this;
        }

        public RenderRequestTypes build() {
            return new RenderRequestTypes(this.suffixAssociation, this.requestsWildcard, this.requestsWildcard || this.entireGroupRequests.isEmpty() ? Collections.emptySet() : this.entireGroupRequests, this.requestsWildcard || this.requestedTypes.isEmpty() ? Collections.emptySet() : this.requestedTypes);
        }
    }
}

