/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.kernel.display.common;

import io.github.spencerpark.jupyter.kernel.display.RenderContext;
import io.github.spencerpark.jupyter.kernel.display.Renderer;
import io.github.spencerpark.jupyter.kernel.display.mime.MIMEType;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import javax.imageio.ImageIO;

public class Image {
    public static final MIMEType PNG = MIMEType.IMAGE_PNG;
    public static final MIMEType JPEG = MIMEType.IMAGE_JPEG;
    public static final MIMEType GIF = MIMEType.IMAGE_GIF;
    public static final MIMEType SVG = MIMEType.IMAGE_SVG;

    public static void registerAll(Renderer renderer) {
        renderer.createRegistration(RenderedImage.class).preferring(PNG).supporting(JPEG, GIF).register(Image::renderImage);
        renderer.createRegistration(InputStream.class).preferring(PNG).supporting(JPEG, GIF).register(Image::renderImageFromStream);
    }

    private static String imageTob64(RenderedImage image, String fmt) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write(image, fmt, Base64.getEncoder().wrap(out));
            return out.toString("UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void renderImage(RenderedImage data, RenderContext context) {
        context.renderIfRequested(PNG, () -> Image.imageTob64(data, "png"));
        context.renderIfRequested(JPEG, () -> Image.imageTob64(data, "jpeg"));
        context.renderIfRequested(GIF, () -> Image.imageTob64(data, "gif"));
    }

    public static void renderImageFromStream(InputStream data, RenderContext context) {
        try {
            Image.renderImage(ImageIO.read(data), context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

