/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.kernel.util;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GlobFinder {
    private static final Pattern GLOB_SEGMENT_COMPONENT = Pattern.compile("(?<literal>[^*?]+)|(?<wildcard>\\*)|(?<singleWildcard>\\?)|(?:\\\\(?<escaped>[*?]))");
    private static final Pattern SPLITTER = Pattern.compile("/+");
    private final Path base;
    private final List<GlobSegment> segments;
    private final boolean isExplicitDirectory;

    public GlobFinder(FileSystem fs, String glob) {
        String[] segments = SPLITTER.split(glob);
        this.isExplicitDirectory = glob.endsWith("/");
        ArrayList<GlobSegment> matchers = new ArrayList<GlobSegment>(segments.length);
        int lastBaseSegmentIdx = 0;
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            StringBuilder pattern = new StringBuilder();
            StringBuilder lit = new StringBuilder();
            int wildcards = 0;
            int singleWildcards = 0;
            Matcher m = GLOB_SEGMENT_COMPONENT.matcher(segment);
            while (m.find()) {
                String literal = m.group("literal");
                if (literal == null) {
                    literal = m.group("escaped");
                }
                if (literal != null) {
                    pattern.append(Pattern.quote(literal));
                    lit.append(literal);
                    continue;
                }
                String wildcard = m.group("wildcard");
                if (wildcard != null) {
                    pattern.append(".*");
                    ++wildcards;
                    continue;
                }
                String singleWildcard = m.group("singleWildcard");
                assert (singleWildcard != null) : "Glob construction pattern incomplete.";
                pattern.append(".");
                ++singleWildcards;
            }
            assert (m.hitEnd()) : "Glob construction missed some characters.";
            if (wildcards == 0 && singleWildcards == 0) {
                matchers.add(new GlobSegment(lit.toString()));
                if (lastBaseSegmentIdx != i) continue;
                ++lastBaseSegmentIdx;
                continue;
            }
            matchers.add(new GlobSegment(Pattern.compile("^" + pattern.toString() + "$")));
        }
        boolean isAbsolute = lastBaseSegmentIdx > 0 && fs.getPath(segments[0] + fs.getSeparator(), new String[0]).isAbsolute();
        String firstSeg = isAbsolute ? segments[0] + fs.getSeparator() : "." + fs.getSeparator();
        this.base = fs.getPath(firstSeg, Arrays.copyOfRange(segments, isAbsolute ? 1 : 0, lastBaseSegmentIdx));
        this.segments = matchers.subList(lastBaseSegmentIdx, matchers.size());
    }

    public GlobFinder(String glob) {
        this(FileSystems.getDefault(), glob);
    }

    public Iterable<Path> computeMatchingPaths() throws IOException {
        if (this.segments.isEmpty()) {
            if (Files.exists(this.base, new LinkOption[0])) {
                return Collections.singletonList(this.base);
            }
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        GlobSegment head = this.segments.get(0);
        List<GlobSegment> tail = this.segments.subList(1, this.segments.size());
        this.collectExplicit(GlobSegment.FilterRestriction.ANYTHING, this.base, head, tail, paths);
        return paths;
    }

    private void collectExplicit(GlobSegment.FilterRestriction finalFilterRestriction, Path dir, GlobSegment segment, List<GlobSegment> segments, Collection<Path> into) throws IOException {
        boolean isMoreSegments = !segments.isEmpty();
        GlobSegment.FilterRestriction filterRestriction = isMoreSegments ? GlobSegment.FilterRestriction.ONLY_DIRECTORIES : finalFilterRestriction;
        try (DirectoryStream<Path> files = Files.newDirectoryStream(dir, segment.filter(filterRestriction));){
            GlobSegment head = isMoreSegments ? segments.get(0) : null;
            List<GlobSegment> tail = isMoreSegments ? segments.subList(1, segments.size()) : Collections.emptyList();
            for (Path p : files) {
                if (isMoreSegments) {
                    this.collectExplicit(finalFilterRestriction, p, head, tail, into);
                    continue;
                }
                into.add(p);
            }
        }
    }

    public Iterable<Path> computeMatchingFiles() throws IOException {
        List<GlobSegment> tail;
        if (this.segments.isEmpty()) {
            if (Files.isDirectory(this.base, new LinkOption[0]) && this.isExplicitDirectory) {
                return Files.newDirectoryStream(this.base, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
            }
            if (Files.isRegularFile(this.base, new LinkOption[0])) {
                return Collections.singleton(this.base);
            }
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        GlobSegment head = this.segments.get(0);
        if (this.isExplicitDirectory) {
            tail = new ArrayList<GlobSegment>(this.segments.size() + 1);
            Collections.copy(tail, this.segments.subList(1, this.segments.size()));
            tail.add(GlobSegment.ANY);
        } else {
            tail = this.segments.subList(1, this.segments.size());
        }
        this.collectExplicit(GlobSegment.FilterRestriction.ONLY_FILES, this.base, head, tail, paths);
        return paths;
    }

    private static class GlobSegment {
        public static final GlobSegment ANY = new GlobSegment(Pattern.compile("^.*$"));
        private final String literal;
        private final Pattern regex;

        public GlobSegment(String literal) {
            this.literal = literal;
            this.regex = null;
        }

        public GlobSegment(Pattern regex) {
            this.literal = null;
            this.regex = regex;
        }

        public boolean isLiteral() {
            return this.literal != null;
        }

        public DirectoryStream.Filter<Path> filter(FilterRestriction restriction) {
            return s -> {
                BasicFileAttributes attributes = Files.readAttributes(s, BasicFileAttributes.class, new LinkOption[0]);
                if (attributes.isRegularFile() && !restriction.acceptsFiles() || attributes.isDirectory() && !restriction.acceptsDirectories()) {
                    return false;
                }
                Path pathName = s.getFileName();
                if (pathName == null) {
                    return false;
                }
                String name = pathName.toString();
                return this.literal != null ? this.literal.equals(name) : this.regex.matcher(name).matches();
            };
        }

        public String toString() {
            return this.isLiteral() ? this.literal : this.regex.pattern();
        }

        public static enum FilterRestriction {
            ONLY_FILES(true, false),
            ONLY_DIRECTORIES(false, true),
            ANYTHING(true, true);

            private final boolean acceptsFiles;
            private final boolean acceptsDirectories;

            private FilterRestriction(boolean acceptsFiles, boolean acceptsDirectories) {
                this.acceptsFiles = acceptsFiles;
                this.acceptsDirectories = acceptsDirectories;
            }

            public boolean acceptsFiles() {
                return this.acceptsFiles;
            }

            public boolean acceptsDirectories() {
                return this.acceptsDirectories;
            }
        }
    }
}

