/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.kernel.util;

import io.github.spencerpark.jupyter.kernel.util.CharPredicate;

public class StringSearch {
    public static Range findLongestMatchingAt(String code, int at, CharPredicate test) {
        int start;
        int end;
        if (test == null || at < 0 || at > code.length()) {
            return null;
        }
        if (at < code.length() && test.test(code.charAt(at))) {
            start = end = at;
        } else if (at > 0 && test.test(code.charAt(at - 1))) {
            start = end = at - 1;
        } else {
            return null;
        }
        while (start > 0 && test.test(code.charAt(start - 1))) {
            --start;
        }
        while (end < code.length() - 1 && test.test(code.charAt(end + 1))) {
            ++end;
        }
        return new Range(start, end + 1);
    }

    public static class Range {
        private final int low;
        private final int high;

        public Range(int low, int high) {
            this.low = low;
            this.high = high;
        }

        public int getLow() {
            return this.low;
        }

        public int getHigh() {
            return this.high;
        }

        public int getLength() {
            return this.high - this.low;
        }

        public String extractSubString(String original) {
            return original.substring(this.low, this.high);
        }
    }
}

