/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.messages;

import io.github.spencerpark.jupyter.channels.JupyterSocket;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACGenerator {
    private static final int MASK_INT_TO_BYTE = 255;
    private static final int MASK_BYTE_LOWER = 15;
    public static final HMACGenerator NO_AUTH_INSTANCE = new HMACGenerator(){

        @Override
        public String calculateSignature(byte[] ... messageParts) {
            return "";
        }
    };
    private final Mac mac;
    private static final char[] HEX_CHAR = "0123456789abcdef".toCharArray();

    public HMACGenerator(String algorithm, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        this.mac = Mac.getInstance(algorithm.replace("-", ""));
        this.mac.init(new SecretKeySpec(key.getBytes(JupyterSocket.ASCII), algorithm));
    }

    private HMACGenerator() {
        this.mac = null;
    }

    public synchronized String calculateSignature(byte[] ... messageParts) {
        for (byte[] part : messageParts) {
            this.mac.update(part);
        }
        byte[] sig = this.mac.doFinal();
        char[] hex = new char[sig.length * 2];
        for (int j = 0; j < sig.length; ++j) {
            int b = sig[j] & 0xFF;
            hex[j * 2] = HEX_CHAR[b >>> 4];
            hex[j * 2 + 1] = HEX_CHAR[b & 0xF];
        }
        return new String(hex);
    }
}

