/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.messages;

import com.google.gson.annotations.SerializedName;
import io.github.spencerpark.jupyter.messages.KernelTimestamp;
import io.github.spencerpark.jupyter.messages.MessageContext;
import io.github.spencerpark.jupyter.messages.MessageType;
import java.util.UUID;

public class Header<T> {
    public static final String KERNEL_USERNAME = "kernel";
    public static final String PROTOCOL_VERISON = "5.3";
    private final String id;
    private final String username;
    @SerializedName(value="session")
    private final String sessionId;
    @SerializedName(value="date")
    private final KernelTimestamp timestamp;
    @SerializedName(value="msg_type")
    private final MessageType<T> type;
    private final String version;

    public Header(MessageType<T> type) {
        this("", type);
    }

    public Header(String sessionId, MessageType<T> type) {
        this(UUID.randomUUID().toString(), KERNEL_USERNAME, sessionId, KernelTimestamp.now(), type, PROTOCOL_VERISON);
    }

    public Header(MessageContext ctx, MessageType<T> type) {
        this(UUID.randomUUID().toString(), ctx != null ? ctx.getHeader().getUsername() : KERNEL_USERNAME, ctx != null ? ctx.getHeader().getSessionId() : null, KernelTimestamp.now(), type, PROTOCOL_VERISON);
    }

    public Header(String id, String username, String sessionId, KernelTimestamp timestamp, MessageType<T> type, String version) {
        this.id = id;
        this.username = username;
        this.sessionId = sessionId;
        this.timestamp = timestamp;
        this.type = type;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public KernelTimestamp getTimestamp() {
        return this.timestamp;
    }

    public MessageType<T> getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }
}

