/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.messages;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class KernelTimestamp {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    });
    private String serialized;
    private Date date;

    public static KernelTimestamp now() {
        return new KernelTimestamp(new Date());
    }

    public KernelTimestamp(String serialized) {
        this.serialized = serialized;
    }

    public KernelTimestamp(Date date) {
        this.date = date;
    }

    public Date getDate() {
        try {
            return this.date != null ? this.date : (this.date = DATE_FORMAT.get().parse(this.serialized));
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date string '" + this.serialized + "'", e);
        }
    }

    public String getDateString() {
        return this.serialized != null ? this.serialized : (this.serialized = DATE_FORMAT.get().format(this.date));
    }
}

