/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.messages.publish;

import com.google.gson.annotations.SerializedName;
import io.github.spencerpark.jupyter.messages.ContentType;
import io.github.spencerpark.jupyter.messages.MessageType;
import io.github.spencerpark.jupyter.messages.publish.ErrorFormatter;
import java.util.List;

public class PublishError
implements ContentType<PublishError> {
    public static final MessageType<PublishError> MESSAGE_TYPE = MessageType.PUBLISH_ERROR;
    @SerializedName(value="ename")
    protected final String errName;
    @SerializedName(value="evalue")
    protected final String errMsg;
    @SerializedName(value="traceback")
    protected final List<String> stacktrace;

    public static PublishError of(Exception exception, ErrorFormatter formatter) {
        String name = exception.getClass().getSimpleName();
        String msg = exception.getLocalizedMessage();
        List<String> stacktrace = formatter.format(exception);
        return new PublishError(name, msg == null ? "" : msg, stacktrace);
    }

    @Override
    public MessageType<PublishError> getType() {
        return MESSAGE_TYPE;
    }

    public PublishError(String errName, String errMsg, List<String> stacktrace) {
        this.errName = errName;
        this.errMsg = errMsg;
        this.stacktrace = stacktrace;
    }

    public String getErrorName() {
        return this.errName;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public List<String> getStacktrace() {
        return this.stacktrace;
    }
}

