/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.messages.reply;

import com.google.gson.annotations.SerializedName;
import io.github.spencerpark.jupyter.messages.MessageType;
import io.github.spencerpark.jupyter.messages.ReplyType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ErrorReply
implements ReplyType<Object> {
    protected final String status = "error";
    @SerializedName(value="ename")
    protected final String errName;
    @SerializedName(value="evalue")
    protected final String errMsg;
    @SerializedName(value="traceback")
    protected final List<String> stacktrace;
    @SerializedName(value="execution_count")
    protected Integer count;

    @Override
    public MessageType<Object> getRequestType() {
        return MessageType.UNKNOWN;
    }

    public static ErrorReply of(Exception exception) {
        String name = exception.getClass().getSimpleName();
        String msg = exception.getLocalizedMessage();
        List<String> stacktrace = Arrays.stream(exception.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.toList());
        return new ErrorReply(name, msg == null ? "" : msg, stacktrace);
    }

    public ErrorReply(String errName, String errMsg, List<String> stacktrace) {
        this.errName = errName;
        this.errMsg = errMsg;
        this.stacktrace = stacktrace;
    }

    public void setExecutionCount(int count) {
        this.count = count;
    }

    public String getStatus() {
        return "error";
    }

    public String getErrorName() {
        return this.errName;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public List<String> getStacktrace() {
        return this.stacktrace;
    }
}

