/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.messages.reply;

import com.google.gson.annotations.SerializedName;
import io.github.spencerpark.jupyter.kernel.ExpressionValue;
import io.github.spencerpark.jupyter.messages.ContentType;
import io.github.spencerpark.jupyter.messages.MessageType;
import io.github.spencerpark.jupyter.messages.ReplyType;
import io.github.spencerpark.jupyter.messages.request.ExecuteRequest;
import java.util.Map;

public class ExecuteReply
implements ContentType<ExecuteReply>,
ReplyType<ExecuteRequest> {
    public static final MessageType<ExecuteReply> MESSAGE_TYPE = MessageType.EXECUTE_REPLY;
    public static final MessageType<ExecuteRequest> REQUEST_MESSAGE_TYPE = MessageType.EXECUTE_REQUEST;
    private final Status status;
    @SerializedName(value="execution_count")
    protected final int executionCount;
    @SerializedName(value="user_expressions")
    protected final Map<String, ExpressionValue> evaluatedUserExpr;

    @Override
    public MessageType<ExecuteReply> getType() {
        return MESSAGE_TYPE;
    }

    @Override
    public MessageType<ExecuteRequest> getRequestType() {
        return REQUEST_MESSAGE_TYPE;
    }

    public ExecuteReply(int executionCount, Map<String, ExpressionValue> evaluatedUserExpr) {
        this.status = Status.OK;
        this.executionCount = executionCount;
        this.evaluatedUserExpr = evaluatedUserExpr;
    }

    public ExecuteReply(int executionCount) {
        this.status = Status.ERROR;
        this.executionCount = executionCount;
        this.evaluatedUserExpr = null;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public Map<String, ExpressionValue> getEvaluatedUserExpr() {
        return this.evaluatedUserExpr;
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

