/*
 * Decompiled with CFR 0.152.
 */
package io.github.spencerpark.jupyter.messages.reply;

import io.github.spencerpark.jupyter.messages.ContentType;
import io.github.spencerpark.jupyter.messages.MessageType;
import io.github.spencerpark.jupyter.messages.ReplyType;
import io.github.spencerpark.jupyter.messages.request.IsCompleteRequest;

public class IsCompleteReply
implements ContentType<IsCompleteReply>,
ReplyType<IsCompleteRequest> {
    public static final MessageType<IsCompleteReply> MESSAGE_TYPE = MessageType.IS_COMPLETE_REPLY;
    public static final MessageType<IsCompleteRequest> REQUEST_MESSAGE_TYPE = MessageType.IS_COMPLETE_REQUEST;
    public static final IsCompleteReply VALID_CODE = new IsCompleteReply(Status.VALID_CODE);
    public static final IsCompleteReply INVALID_CODE = new IsCompleteReply(Status.INVALID_CODE);
    public static final IsCompleteReply UNKNOWN = new IsCompleteReply(Status.UNKNOWN);
    private static final IsCompleteReply[] COMMON_INDENTS = new IsCompleteReply[]{new IsCompleteReply(Status.NOT_FINISHED, ""), new IsCompleteReply(Status.NOT_FINISHED, " "), new IsCompleteReply(Status.NOT_FINISHED, "  "), new IsCompleteReply(Status.NOT_FINISHED, "   "), new IsCompleteReply(Status.NOT_FINISHED, "    "), new IsCompleteReply(Status.NOT_FINISHED, "     "), new IsCompleteReply(Status.NOT_FINISHED, "      "), new IsCompleteReply(Status.NOT_FINISHED, "       "), new IsCompleteReply(Status.NOT_FINISHED, "        "), new IsCompleteReply(Status.NOT_FINISHED, "\t"), new IsCompleteReply(Status.NOT_FINISHED, "\t\t")};
    protected final Status status;
    protected final String indent;

    @Override
    public MessageType<IsCompleteReply> getType() {
        return MESSAGE_TYPE;
    }

    @Override
    public MessageType<IsCompleteRequest> getRequestType() {
        return REQUEST_MESSAGE_TYPE;
    }

    public static IsCompleteReply getIncompleteReplyWithIndent(String indent) {
        switch (indent) {
            case "": {
                return COMMON_INDENTS[0];
            }
            case " ": {
                return COMMON_INDENTS[1];
            }
            case "  ": {
                return COMMON_INDENTS[2];
            }
            case "   ": {
                return COMMON_INDENTS[3];
            }
            case "    ": {
                return COMMON_INDENTS[4];
            }
            case "     ": {
                return COMMON_INDENTS[5];
            }
            case "      ": {
                return COMMON_INDENTS[6];
            }
            case "       ": {
                return COMMON_INDENTS[7];
            }
            case "        ": {
                return COMMON_INDENTS[8];
            }
            case "\t": {
                return COMMON_INDENTS[9];
            }
            case "\t\t": {
                return COMMON_INDENTS[10];
            }
        }
        return new IsCompleteReply(Status.NOT_FINISHED, indent);
    }

    private IsCompleteReply(Status status) {
        this.status = status;
        this.indent = "";
    }

    private IsCompleteReply(Status status, String indent) {
        this.status = status;
        this.indent = indent;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getIndent() {
        return this.indent;
    }

    public static enum Status {
        VALID_CODE,
        NOT_FINISHED,
        INVALID_CODE,
        UNKNOWN;

    }
}

