/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.jar.Manifest;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.core.BundleArtifact;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.StringUtils;

public class OSGiManifestParser
implements ModuleDescriptorParser {
    private static final OSGiManifestParser INSTANCE = new OSGiManifestParser();
    private ExecutionEnvironmentProfileProvider profileProvider = ExecutionEnvironmentProfileProvider.getInstance();

    public static OSGiManifestParser getInstance() {
        return INSTANCE;
    }

    public void add(ExecutionEnvironmentProfileProvider pp) {
        this.profileProvider = pp;
    }

    @Override
    public boolean accept(Resource res) {
        return res != null && !StringUtils.isNullOrEmpty(res.getName()) && res.getName().toUpperCase(Locale.US).endsWith("MANIFEST.MF");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL descriptorURL, Resource res, boolean validate) throws ParseException, IOException {
        Manifest manifest;
        InputStream resourceStream = res.openStream();
        try {
            manifest = new Manifest(resourceStream);
        }
        finally {
            try {
                resourceStream.close();
            }
            catch (Exception exception) {}
        }
        BundleInfo bundleInfo = ManifestParser.parseManifest(manifest);
        try {
            bundleInfo.addArtifact(new BundleArtifact(false, descriptorURL.toURI(), null));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unsupported repository, resources names are not uris", e);
        }
        return BundleInfoAdapter.toModuleDescriptor(this, null, bundleInfo, manifest, this.profileProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toIvyFile(InputStream is, Resource res, File destFile, ModuleDescriptor md) throws ParseException, IOException {
        try {
            XmlModuleDescriptorWriter.write(md, destFile);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL descriptorURL, boolean validate) throws ParseException, IOException {
        URLResource resource = new URLResource(descriptorURL);
        return this.parseDescriptor(ivySettings, descriptorURL, resource, validate);
    }

    @Override
    public String getType() {
        return "manifest";
    }

    @Override
    public Artifact getMetadataArtifact(ModuleRevisionId mrid, Resource res) {
        return DefaultArtifact.newIvyArtifact(mrid, new Date(res.getLastModified()));
    }

    public String toString() {
        return "manifest parser";
    }
}

