/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism.plain;

import zmq.Msg;
import zmq.Options;
import zmq.io.SessionBase;
import zmq.io.mechanism.Mechanism;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.Address;

public class PlainServerMechanism
extends Mechanism {
    private State state = State.WAITING_FOR_HELLO;

    public PlainServerMechanism(SessionBase session, Address peerAddress, Options options) {
        super(session, peerAddress, options);
    }

    @Override
    public int nextHandshakeCommand(Msg msg) {
        int rc;
        switch (this.state) {
            case SENDING_WELCOME: {
                rc = this.produceWelcome(msg);
                if (rc != 0) break;
                this.state = State.WAITING_FOR_INITIATE;
                break;
            }
            case SENDING_READY: {
                rc = this.produceReady(msg);
                if (rc != 0) break;
                this.state = State.READY;
                break;
            }
            case SENDING_ERROR: {
                rc = this.produceError(msg);
                if (rc != 0) break;
                this.state = State.ERROR_COMMAND_SENT;
                break;
            }
            default: {
                rc = 35;
            }
        }
        return rc;
    }

    @Override
    public int processHandshakeCommand(Msg msg) {
        int rc;
        switch (this.state) {
            case WAITING_FOR_HELLO: {
                rc = this.produceHello(msg);
                break;
            }
            case WAITING_FOR_INITIATE: {
                rc = this.produceInitiate(msg);
                break;
            }
            default: {
                rc = 156384820;
            }
        }
        return rc;
    }

    @Override
    public Mechanism.Status status() {
        if (this.state == State.READY) {
            return Mechanism.Status.READY;
        }
        if (this.state == State.ERROR_COMMAND_SENT) {
            return Mechanism.Status.ERROR;
        }
        return Mechanism.Status.HANDSHAKING;
    }

    @Override
    public int zapMsgAvailable() {
        if (this.state != State.WAITING_FOR_ZAP_REPLY) {
            return 156384763;
        }
        int rc = this.receiveAndProcessZapReply();
        if (rc == 0) {
            this.state = "200".equals(this.statusCode) ? State.SENDING_WELCOME : State.SENDING_ERROR;
        }
        return rc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int produceHello(Msg msg) {
        int bytesLeft = msg.size();
        int index = 0;
        if (bytesLeft < 6) return 156384820;
        if (!this.compare(msg, "HELLO", true)) {
            return 156384820;
        }
        index += 6;
        if ((bytesLeft -= 6) < 1) {
            return 156384820;
        }
        byte length = msg.get(index);
        if (--bytesLeft < length) {
            return 156384820;
        }
        byte[] tmp = new byte[length];
        msg.getBytes(++index, tmp, 0, length);
        byte[] username = tmp;
        bytesLeft -= length;
        index += length;
        length = msg.get(index);
        if (--bytesLeft < length) {
            return 156384820;
        }
        tmp = new byte[length];
        msg.getBytes(++index, tmp, 0, length);
        byte[] password = tmp;
        if ((bytesLeft -= length) > 0) {
            return 156384820;
        }
        int rc = this.session.zapConnect();
        if (rc == 0) {
            this.sendZapRequest(username, password);
            rc = this.receiveAndProcessZapReply();
            if (rc == 0) {
                this.state = "200".equals(this.statusCode) ? State.SENDING_WELCOME : State.SENDING_ERROR;
                return 0;
            } else {
                if (rc != 35) return -1;
                this.state = State.WAITING_FOR_ZAP_REPLY;
            }
            return 0;
        } else {
            this.state = State.SENDING_WELCOME;
        }
        return 0;
    }

    private int produceWelcome(Msg msg) {
        msg.putShortString("WELCOME");
        return 0;
    }

    private int produceInitiate(Msg msg) {
        int bytesLeft = msg.size();
        if (bytesLeft < 9 || !this.compare(msg, "INITIATE", true)) {
            return 156384820;
        }
        int rc = this.parseMetadata(msg, 9, false);
        if (rc == 0) {
            this.state = State.SENDING_READY;
        }
        return rc;
    }

    private int produceReady(Msg msg) {
        msg.putShortString("READY");
        String socketType = this.socketType(this.options.type);
        this.addProperty(msg, "Socket-Type", socketType);
        if (this.options.type == 3 || this.options.type == 5 || this.options.type == 6) {
            this.addProperty(msg, "Identity", this.options.identity);
        }
        return 0;
    }

    private int produceError(Msg msg) {
        assert (this.statusCode != null && this.statusCode.length() == 3);
        msg.putShortString("ERROR");
        msg.putShortString(this.statusCode);
        return 0;
    }

    private void sendZapRequest(byte[] username, byte[] password) {
        this.sendZapRequest(Mechanisms.PLAIN, true);
        Msg msg = new Msg(username.length);
        msg.setFlags(1);
        msg.put(username);
        boolean rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(password.length);
        msg.put(password);
        rc = this.session.writeZapMsg(msg);
        assert (rc);
    }

    private static enum State {
        WAITING_FOR_HELLO,
        SENDING_WELCOME,
        WAITING_FOR_INITIATE,
        SENDING_READY,
        WAITING_FOR_ZAP_REPLY,
        SENDING_ERROR,
        ERROR_COMMAND_SENT,
        READY;

    }
}

