/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.reqrep;

import zmq.Ctx;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;
import zmq.pipe.Pipe;
import zmq.socket.FQ;
import zmq.socket.LB;
import zmq.util.Blob;
import zmq.util.ValueReference;

public class Dealer
extends SocketBase {
    private final FQ fq;
    private final LB lb;
    private boolean probeRouter;

    public Dealer(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 5;
        this.fq = new FQ();
        this.lb = new LB();
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean subscribe2all, boolean isLocallyInitiated) {
        assert (pipe != null);
        if (this.probeRouter) {
            Msg probe = new Msg();
            pipe.write(probe);
            pipe.flush();
        }
        this.fq.attach(pipe);
        this.lb.attach(pipe);
    }

    @Override
    protected boolean xsetsockopt(int option, Object optval) {
        if (option == 51) {
            this.probeRouter = Options.parseBoolean(option, optval);
            return true;
        }
        this.errno.set(22);
        return false;
    }

    @Override
    protected boolean xsend(Msg msg) {
        return this.sendpipe(msg, null);
    }

    @Override
    protected Msg xrecv() {
        return this.recvpipe(null);
    }

    @Override
    protected boolean xhasIn() {
        return this.fq.hasIn();
    }

    @Override
    protected boolean xhasOut() {
        return this.lb.hasOut();
    }

    @Override
    protected Blob getCredential() {
        return this.fq.getCredential();
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
        this.fq.activated(pipe);
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
        this.lb.activated(pipe);
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        this.fq.terminated(pipe);
        this.lb.terminated(pipe);
    }

    protected final boolean sendpipe(Msg msg, ValueReference<Pipe> pipe) {
        return this.lb.sendpipe(msg, this.errno, pipe);
    }

    protected final Msg recvpipe(ValueReference<Pipe> pipe) {
        return this.fq.recvPipe(this.errno, pipe);
    }
}

