/*
 * Decompiled with CFR 0.152.
 */
package zmq.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import zmq.ZMQ;
import zmq.util.Clock;
import zmq.util.MultiMap;

public final class Timers {
    private static final long ONE_MILLISECOND = 1L;
    private final MultiMap<Long, Timer> timers = new MultiMap();
    private final Set<Timer> cancelledTimers = new HashSet<Timer>();

    private long now() {
        return Clock.nowNS();
    }

    private boolean insert(Timer timer) {
        return this.timers.insert(this.now() + timer.interval, timer);
    }

    public Timer add(long interval, Handler handler, Object ... args) {
        if (handler == null) {
            return null;
        }
        Timer timer = new Timer(TimeUnit.MILLISECONDS.toNanos(interval), handler, args);
        boolean rc = this.insert(timer);
        assert (rc);
        return timer;
    }

    public boolean setInterval(Timer timer, long interval) {
        if (this.timers.remove(timer)) {
            timer.interval = TimeUnit.MILLISECONDS.toNanos(interval);
            return this.insert(timer);
        }
        return false;
    }

    public boolean reset(Timer timer) {
        if (this.timers.contains(timer)) {
            return this.insert(timer);
        }
        return false;
    }

    public boolean cancel(Timer timer) {
        if (this.timers.contains(timer)) {
            return this.cancelledTimers.add(timer);
        }
        return false;
    }

    public long timeout() {
        long now = this.now();
        for (Map.Entry<Timer, Long> entry : this.timers.entries()) {
            Timer timer = entry.getKey();
            Long timeout = entry.getValue();
            if (!this.cancelledTimers.remove(timer)) {
                if (timeout - now > 0L) {
                    return 1L + TimeUnit.NANOSECONDS.toMillis(timeout - now);
                }
                return 0L;
            }
            this.timers.remove(timeout, timer);
        }
        return -1L;
    }

    public int execute() {
        int executed = 0;
        long now = this.now();
        for (Map.Entry<Timer, Long> entry : this.timers.entries()) {
            Timer timer = entry.getKey();
            Long timeout = entry.getValue();
            if (this.cancelledTimers.remove(timer)) {
                this.timers.remove(timeout, timer);
                continue;
            }
            if (timeout - now > 0L) break;
            this.insert(timer);
            timer.handler.time(timer.args);
            ++executed;
        }
        return executed;
    }

    public int sleepAndExecute() {
        long timeout = this.timeout();
        while (timeout > 0L) {
            ZMQ.msleep(timeout);
            timeout = this.timeout();
        }
        return this.execute();
    }

    public static interface Handler {
        public void time(Object ... var1);
    }

    public static final class Timer {
        private long interval;
        private final Handler handler;
        private final Object[] args;

        public Timer(long interval, Handler handler, Object ... args) {
            this.interval = interval;
            this.handler = handler;
            this.args = args;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.args);
            result = 31 * result + (this.handler == null ? 0 : this.handler.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Timer other = (Timer)obj;
            if (this.handler == null ? other.handler != null : !this.handler.equals(other.handler)) {
                return false;
            }
            return Arrays.equals(this.args, other.args);
        }
    }
}

