/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows;

import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.decorations.CustomTitlePane;
import com.github.weisj.darklaf.decorations.DecorationsProvider;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.platform.PointerUtil;
import com.github.weisj.darklaf.platform.windows.JNIDecorationsWindows;
import com.github.weisj.darklaf.platform.windows.ui.WindowsTitlePane;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.JRootPane;
import javax.swing.UIDefaults;

public class WindowsDecorationsProvider
implements DecorationsProvider {
    public CustomTitlePane createTitlePane(JRootPane rootPane, int decorationStyle, Window window) {
        return new WindowsTitlePane(rootPane, decorationStyle, window);
    }

    public boolean isCustomDecorationSupported() {
        return JNIDecorationsWindows.isCustomDecorationSupported();
    }

    public void initialize() {
        JNIDecorationsWindows.updateLibrary();
    }

    public void installPopupMenu(Window window) {
        long hwnd;
        if (!window.isDisplayable()) {
            window.addNotify();
        }
        if ((hwnd = PointerUtil.getHWND((Component)window)) != 0L) {
            JNIDecorationsWindows.installPopupMenuDecorations(hwnd);
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JNIDecorationsWindows.uninstallDecorations(hwnd);
                }
            });
        }
    }

    public void uninstallPopupWindow(Window window) {
        if (window.isDisplayable()) {
            long hwnd = PointerUtil.getHWND((Component)window);
            if (hwnd != 0L) {
                JNIDecorationsWindows.uninstallDecorations(hwnd);
            }
            window.dispose();
        }
    }

    public void loadDecorationProperties(Properties properties, UIDefaults currentDefaults) {
        IconLoader iconLoader = IconLoader.get(WindowsDecorationsProvider.class);
        PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(WindowsDecorationsProvider.class, (String)"windows_decorations", (String)""), (Properties)properties, (UIDefaults)currentDefaults, (IconLoader)iconLoader);
        PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(WindowsDecorationsProvider.class, (String)"windows_icons", (String)""), (Properties)properties, (UIDefaults)currentDefaults, (IconLoader)iconLoader);
    }
}

