/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.aggregators;

import java.util.Arrays;
import java.util.List;
import net.semanticmetadata.lire.aggregators.AbstractAggregator;
import net.semanticmetadata.lire.classifiers.Cluster;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class BOVW
extends AbstractAggregator {
    private double[] histogram;

    @Override
    public void createVectorRepresentation(List<? extends LocalFeature> listOfLocalFeatures, Cluster[] clustersArray) {
        this.histogram = new double[clustersArray.length];
        Arrays.fill(this.histogram, 0.0);
        for (LocalFeature localFeature : listOfLocalFeatures) {
            int n = this.clusterForFeature(localFeature.getFeatureVector(), clustersArray);
            this.histogram[n] = this.histogram[n] + 1.0;
        }
    }

    @Override
    public byte[] getByteVectorRepresentation() {
        return SerializationUtils.toByteArray(this.histogram);
    }

    @Override
    public String getStringVectorRepresentation() {
        return this.arrayToVisualWordString(this.histogram);
    }

    @Override
    public double[] getVectorRepresentation() {
        return this.histogram;
    }

    @Override
    public String getFieldName() {
        return "BOVW";
    }

    public String toString() {
        return SerializationUtils.toString(this.histogram);
    }

    private void quantize(double[] data) {
        double max = 0.0;
        for (double next : data) {
            max = Math.max(max, next);
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = (int)Math.floor(data[i] * 128.0 / max);
        }
    }

    private String arrayToVisualWordString(double[] data) {
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < data.length; ++i) {
            int visualWordIndex = (int)data[i];
            for (int j = 0; j < visualWordIndex; ++j) {
                sb.append(Integer.toHexString(i));
                sb.append(' ');
            }
        }
        return sb.toString();
    }
}

