/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.aggregators;

import java.util.Arrays;
import java.util.List;
import net.semanticmetadata.lire.aggregators.AbstractAggregator;
import net.semanticmetadata.lire.classifiers.Cluster;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class ShapemeAggregator
extends AbstractAggregator {
    private int[] histogram;

    public void createVisualWords(List<? extends LocalFeature> list, Cluster[] clusters) {
        this.histogram = new int[clusters.length];
        Arrays.fill(this.histogram, 0);
        for (LocalFeature localFeature : list) {
            int n = this.clusterForFeature(localFeature.getFeatureVector(), clusters);
            this.histogram[n] = this.histogram[n] + 1;
        }
    }

    @Override
    public void createVectorRepresentation(List<? extends LocalFeature> list, Cluster[] clusters) {
        this.createVisualWords(list, clusters);
    }

    @Override
    public byte[] getByteVectorRepresentation() {
        return SerializationUtils.toByteArray(this.histogram);
    }

    @Override
    public String getStringVectorRepresentation() {
        return this.arrayToVisualWordString(this.histogram);
    }

    @Override
    public double[] getVectorRepresentation() {
        double[] histTmp = new double[this.histogram.length];
        for (int i : this.histogram) {
            histTmp[i] = this.histogram[i];
        }
        return histTmp;
    }

    @Override
    public String getFieldName() {
        return "ShapeContext";
    }

    public String toString() {
        throw new UnsupportedOperationException();
    }

    private String arrayToVisualWordString(int[] data) {
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < data.length; ++i) {
            int visualWordIndex = data[i];
            for (int j = 0; j < visualWordIndex; ++j) {
                sb.append(Integer.toHexString(i));
                sb.append(' ');
            }
        }
        return sb.toString();
    }
}

