/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.aggregators;

import java.util.Arrays;
import java.util.List;
import net.semanticmetadata.lire.aggregators.AbstractAggregator;
import net.semanticmetadata.lire.classifiers.Cluster;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class VLAD
extends AbstractAggregator {
    private double[] vector;

    @Override
    public void createVectorRepresentation(List<? extends LocalFeature> listOfLocalFeatures, Cluster[] clustersArray) {
        this.vector = new double[clustersArray.length * clustersArray[0].getMean().length];
        Arrays.fill(this.vector, 0.0);
        for (LocalFeature localFeature : listOfLocalFeatures) {
            int clusterIndex = this.clusterForFeature(localFeature.getFeatureVector(), clustersArray);
            double[] mean = clustersArray[clusterIndex].getMean();
            for (int i = 0; i < localFeature.getFeatureVector().length; ++i) {
                int n = clusterIndex * localFeature.getFeatureVector().length + i;
                this.vector[n] = this.vector[n] + (localFeature.getFeatureVector()[i] - mean[i]);
            }
        }
        this.normalize(this.vector);
    }

    @Override
    public byte[] getByteVectorRepresentation() {
        return SerializationUtils.toByteArray(this.vector);
    }

    @Override
    public String getStringVectorRepresentation() {
        return SerializationUtils.toString(this.vector);
    }

    @Override
    public double[] getVectorRepresentation() {
        return this.vector;
    }

    @Override
    public String getFieldName() {
        return "VLAD";
    }

    public String toString() {
        return this.getStringVectorRepresentation();
    }

    private void normalize(double[] histogram) {
        double sumOfSquares = 0.0;
        for (double next : histogram) {
            sumOfSquares += next * next;
        }
        if (sumOfSquares > 0.0) {
            sumOfSquares = Math.sqrt(sumOfSquares);
            int i = 0;
            while (i < histogram.length) {
                int n = i++;
                histogram[n] = histogram[n] / sumOfSquares;
            }
        }
    }
}

