/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.builders;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.semanticmetadata.lire.aggregators.AbstractAggregator;
import net.semanticmetadata.lire.aggregators.BOVW;
import net.semanticmetadata.lire.builders.DocumentBuilder;
import net.semanticmetadata.lire.classifiers.Cluster;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.indexers.parallel.ExtractorItem;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public abstract class AbstractLocalDocumentBuilder
implements DocumentBuilder {
    protected HashMap<ExtractorItem, LinkedList<Cluster[]>> extractorItems = new HashMap(10);
    protected HashMap<ExtractorItem, HashMap<Integer, String[]>> fieldNamesDictionary = new HashMap(10);
    protected AbstractAggregator aggregator = new BOVW();
    protected boolean docsCreated = false;

    public LocalFeatureExtractor extractLocalFeatures(BufferedImage image, LocalFeatureExtractor localFeatureExtractor) {
        assert (image != null);
        if (Math.max(image.getHeight(), image.getWidth()) > 1024) {
            image = ImageUtils.scaleImage(image, 1024);
        }
        localFeatureExtractor.extract(image);
        return localFeatureExtractor;
    }

    private Field[] getLocalDescriptorFields(BufferedImage image, ExtractorItem extractorItem, LinkedList<Cluster[]> listOfCodebooks) {
        LocalFeatureExtractor localFeatureExtractor = this.extractLocalFeatures(image, (LocalFeatureExtractor)extractorItem.getExtractorInstance());
        return this.createLocalDescriptorFields(localFeatureExtractor.getFeatures(), extractorItem, listOfCodebooks);
    }

    public Field[] createLocalDescriptorFields(List<? extends LocalFeature> listOfLocalFeatures, ExtractorItem extractorItem, LinkedList<Cluster[]> listOfCodebooks) {
        Field[] result = new Field[listOfCodebooks.size() * 2];
        int count = 0;
        for (Cluster[] codebook : listOfCodebooks) {
            this.aggregator.createVectorRepresentation(listOfLocalFeatures, codebook);
            result[count] = new StoredField(this.fieldNamesDictionary.get(extractorItem).get(codebook.length)[0], this.aggregator.getByteVectorRepresentation());
            result[count + 1] = new TextField(this.fieldNamesDictionary.get(extractorItem).get(codebook.length)[1], this.aggregator.getStringVectorRepresentation(), Field.Store.YES);
            count += 2;
        }
        return result;
    }

    @Override
    public Field[] createDescriptorFields(BufferedImage image) {
        this.docsCreated = true;
        LinkedList resultList = new LinkedList();
        if (this.extractorItems.size() > 0) {
            for (Map.Entry<ExtractorItem, LinkedList<Cluster[]>> extractorItemEntry : this.extractorItems.entrySet()) {
                Field[] fields = this.getLocalDescriptorFields(image, extractorItemEntry.getKey(), extractorItemEntry.getValue());
                Collections.addAll(resultList, fields);
            }
        }
        return resultList.toArray(new Field[resultList.size()]);
    }

    @Override
    public Document createDocument(BufferedImage image, String identifier) {
        Field[] fields;
        Document doc = new Document();
        if (identifier != null) {
            doc.add((IndexableField)new StringField("ImageIdentifier", identifier, Field.Store.YES));
        }
        for (Field field : fields = this.createDescriptorFields(image)) {
            doc.add((IndexableField)field);
        }
        return doc;
    }
}

