/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.builders;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.semanticmetadata.lire.builders.DocumentBuilder;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.indexers.hashing.BitSampling;
import net.semanticmetadata.lire.indexers.hashing.LocalitySensitiveHashing;
import net.semanticmetadata.lire.indexers.hashing.MetricSpaces;
import net.semanticmetadata.lire.indexers.parallel.ExtractorItem;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class GlobalDocumentBuilder
implements DocumentBuilder {
    private boolean useDocValues = false;
    private HashingMode hashingMode = HashingMode.BitSampling;
    private boolean hashingEnabled = false;
    private HashMap<ExtractorItem, String[]> extractorItems = new HashMap(10);
    private boolean docsCreated = false;

    public GlobalDocumentBuilder() {
    }

    public GlobalDocumentBuilder(boolean hashing) {
        this.hashingEnabled = hashing;
        if (this.hashingEnabled) {
            GlobalDocumentBuilder.testHashes();
        }
    }

    public GlobalDocumentBuilder(boolean hashing, HashingMode hashingMode) {
        this.hashingEnabled = hashing;
        this.hashingMode = hashingMode;
        if (this.hashingEnabled) {
            GlobalDocumentBuilder.testHashes();
        }
    }

    public GlobalDocumentBuilder(boolean hashing, HashingMode hashingMode, boolean useDocValues) {
        this.hashingEnabled = hashing;
        this.hashingMode = hashingMode;
        this.useDocValues = useDocValues;
        if (this.hashingEnabled) {
            GlobalDocumentBuilder.testHashes();
        }
    }

    public GlobalDocumentBuilder(Class<? extends GlobalFeature> globalFeatureClass) {
        this.addExtractor(globalFeatureClass);
    }

    public GlobalDocumentBuilder(Class<? extends GlobalFeature> globalFeatureClass, boolean hashing) {
        this.addExtractor(globalFeatureClass);
        this.hashingEnabled = hashing;
        if (this.hashingEnabled) {
            GlobalDocumentBuilder.testHashes();
        }
    }

    public GlobalDocumentBuilder(Class<? extends GlobalFeature> globalFeatureClass, boolean hashing, boolean useDocValues) {
        this.addExtractor(globalFeatureClass);
        this.useDocValues = useDocValues;
        this.hashingEnabled = hashing;
        if (this.hashingEnabled) {
            GlobalDocumentBuilder.testHashes();
        }
    }

    public GlobalDocumentBuilder(ExtractorItem extractorItem) {
        this.addExtractor(extractorItem);
    }

    public void addExtractor(Class<? extends GlobalFeature> globalFeatureClass) {
        this.addExtractor(new ExtractorItem(globalFeatureClass));
    }

    public void addExtractor(ExtractorItem extractorItem) {
        if (this.docsCreated) {
            throw new UnsupportedOperationException("Cannot modify builder after documents have been created!");
        }
        if (!extractorItem.isGlobal()) {
            throw new UnsupportedOperationException("ExtractorItem must contain GlobalFeature");
        }
        String fieldName = extractorItem.getFieldName();
        this.extractorItems.put(extractorItem, new String[]{fieldName, fieldName + "_hash"});
    }

    private static void testHashes() {
        try {
            BitSampling.readHashFunctions();
        }
        catch (Exception e) {
            System.err.println("Could not read BitSampling hashes from file when first creating a GlobalDocumentBuilder instance.");
            e.printStackTrace();
        }
    }

    public GlobalFeature extractGlobalFeature(BufferedImage image, GlobalFeature globalFeature) {
        assert (image != null);
        if (Math.max(image.getHeight(), image.getWidth()) > 1024) {
            image = ImageUtils.scaleImage(image, 1024);
        }
        globalFeature.extract(image);
        return globalFeature;
    }

    private Field[] getGlobalDescriptorFields(BufferedImage image, ExtractorItem extractorItem) {
        TextField hash = null;
        Object vector = null;
        GlobalFeature globalFeature = this.extractGlobalFeature(image, (GlobalFeature)extractorItem.getExtractorInstance());
        vector = !this.useDocValues ? new StoredField(this.extractorItems.get(extractorItem)[0], new BytesRef(globalFeature.getByteArrayRepresentation())) : new BinaryDocValuesField(this.extractorItems.get(extractorItem)[0], new BytesRef(globalFeature.getByteArrayRepresentation()));
        if (this.hashingEnabled) {
            if (globalFeature.getFeatureVector().length <= 3100) {
                if (this.hashingMode == HashingMode.BitSampling) {
                    int[] hashes = BitSampling.generateHashes(globalFeature.getFeatureVector());
                    hash = new TextField(this.extractorItems.get(extractorItem)[1], SerializationUtils.arrayToString(hashes), Field.Store.YES);
                } else if (this.hashingMode == HashingMode.LSH) {
                    int[] hashes = LocalitySensitiveHashing.generateHashes(globalFeature.getFeatureVector());
                    hash = new TextField(this.extractorItems.get(extractorItem)[1], SerializationUtils.arrayToString(hashes), Field.Store.YES);
                } else if (this.hashingMode == HashingMode.MetricSpaces && MetricSpaces.supportsFeature(globalFeature)) {
                    hash = new TextField(this.extractorItems.get(extractorItem)[1], MetricSpaces.generateHashString(globalFeature), Field.Store.YES);
                }
            } else {
                System.err.println("Could not create hashes, feature vector too long: " + globalFeature.getFeatureVector().length + " (" + globalFeature.getClass().getName() + ")");
            }
        }
        Field[] result = hash != null ? new Field[]{vector, hash} : new Field[]{vector};
        return result;
    }

    @Override
    public Field[] createDescriptorFields(BufferedImage image) {
        this.docsCreated = true;
        LinkedList resultList = new LinkedList();
        if (this.extractorItems.size() > 0) {
            for (Map.Entry<ExtractorItem, String[]> extractorItemEntry : this.extractorItems.entrySet()) {
                Field[] fields = this.getGlobalDescriptorFields(image, extractorItemEntry.getKey());
                Collections.addAll(resultList, fields);
            }
        }
        return resultList.toArray(new Field[resultList.size()]);
    }

    @Override
    public Document createDocument(BufferedImage image, String identifier) {
        Field[] fields;
        Document doc = new Document();
        if (identifier != null) {
            doc.add((IndexableField)new StringField("ImageIdentifier", identifier, Field.Store.YES));
        }
        for (Field field : fields = this.createDescriptorFields(image)) {
            doc.add((IndexableField)field);
        }
        return doc;
    }

    public static enum HashingMode {
        BitSampling,
        LSH,
        MetricSpaces,
        None;

    }
}

