/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.builders;

import java.util.HashMap;
import java.util.LinkedList;
import net.semanticmetadata.lire.aggregators.AbstractAggregator;
import net.semanticmetadata.lire.builders.AbstractLocalDocumentBuilder;
import net.semanticmetadata.lire.classifiers.Cluster;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.indexers.parallel.ExtractorItem;

public class LocalDocumentBuilder
extends AbstractLocalDocumentBuilder {
    public LocalDocumentBuilder() {
    }

    public LocalDocumentBuilder(Class<? extends LocalFeatureExtractor> localFeatureExtractorClass, Cluster[] codebook) {
        this.addExtractor(localFeatureExtractorClass, codebook);
    }

    public LocalDocumentBuilder(Class<? extends LocalFeatureExtractor> localFeatureExtractorClass, LinkedList<Cluster[]> listOfCodebooks) {
        this.addExtractor(localFeatureExtractorClass, listOfCodebooks);
    }

    public LocalDocumentBuilder(ExtractorItem extractorItem, Cluster[] codebook) {
        this.addExtractor(extractorItem, codebook);
    }

    public LocalDocumentBuilder(ExtractorItem extractorItem, LinkedList<Cluster[]> listOfCodebooks) {
        this.addExtractor(extractorItem, listOfCodebooks);
    }

    public LocalDocumentBuilder(Class<? extends AbstractAggregator> aggregatorClass) {
        try {
            this.aggregator = aggregatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public LocalDocumentBuilder(Class<? extends LocalFeatureExtractor> localFeatureExtractorClass, Cluster[] codebook, Class<? extends AbstractAggregator> aggregatorClass) {
        try {
            this.aggregator = aggregatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.addExtractor(localFeatureExtractorClass, codebook);
    }

    public LocalDocumentBuilder(Class<? extends LocalFeatureExtractor> localFeatureExtractorClass, LinkedList<Cluster[]> listOfCodebooks, Class<? extends AbstractAggregator> aggregatorClass) {
        try {
            this.aggregator = aggregatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.addExtractor(localFeatureExtractorClass, listOfCodebooks);
    }

    public LocalDocumentBuilder(ExtractorItem extractorItem, Cluster[] codebook, Class<? extends AbstractAggregator> aggregatorClass) {
        try {
            this.aggregator = aggregatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.addExtractor(extractorItem, codebook);
    }

    public LocalDocumentBuilder(ExtractorItem extractorItem, LinkedList<Cluster[]> listOfCodebooks, Class<? extends AbstractAggregator> aggregatorClass) {
        try {
            this.aggregator = aggregatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.addExtractor(extractorItem, listOfCodebooks);
    }

    public void addExtractor(Class<? extends LocalFeatureExtractor> localFeatureExtractorClass, Cluster[] codebook) {
        if (codebook.length <= 0 || codebook == null) {
            throw new UnsupportedOperationException("Codebook cannot be empty or null!!");
        }
        LinkedList<Cluster[]> listOfCodebooks = new LinkedList<Cluster[]>();
        listOfCodebooks.add(codebook);
        this.addExtractor(new ExtractorItem(localFeatureExtractorClass), listOfCodebooks);
    }

    public void addExtractor(ExtractorItem extractorItem, Cluster[] codebook) {
        if (codebook.length <= 0 || codebook == null) {
            throw new UnsupportedOperationException("Codebook cannot be empty or null!!");
        }
        LinkedList<Cluster[]> listOfCodebooks = new LinkedList<Cluster[]>();
        listOfCodebooks.add(codebook);
        this.addExtractor(extractorItem, listOfCodebooks);
    }

    public void addExtractor(Class<? extends LocalFeatureExtractor> localFeatureExtractorClass, LinkedList<Cluster[]> listOfCodebooks) {
        if (listOfCodebooks.size() <= 0 || listOfCodebooks == null) {
            throw new UnsupportedOperationException("List of codebooks cannot be empty or null!!");
        }
        this.addExtractor(new ExtractorItem(localFeatureExtractorClass), listOfCodebooks);
    }

    public void addExtractor(ExtractorItem extractorItem, LinkedList<Cluster[]> listOfCodebooks) {
        if (this.docsCreated) {
            throw new UnsupportedOperationException("Cannot modify builder after documents have been created!");
        }
        if (!extractorItem.isLocal()) {
            throw new UnsupportedOperationException("ExtractorItem must contain LocalFeatureExtractor");
        }
        if (listOfCodebooks.size() <= 0 || listOfCodebooks == null) {
            throw new UnsupportedOperationException("List of codebooks cannot be empty or null!!");
        }
        HashMap<Integer, String[]> mapOfFieldNames = new HashMap<Integer, String[]>(listOfCodebooks.size());
        String fieldName = extractorItem.getFieldName() + this.aggregator.getFieldName();
        for (Cluster[] codebook : listOfCodebooks) {
            String[] strArr = new String[]{fieldName + codebook.length, fieldName + codebook.length + "Str"};
            mapOfFieldNames.put(codebook.length, strArr);
        }
        this.extractorItems.put(extractorItem, listOfCodebooks);
        this.fieldNamesDictionary.put(extractorItem, mapOfFieldNames);
    }
}

