/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.builders;

import java.util.HashMap;
import java.util.LinkedList;
import net.semanticmetadata.lire.aggregators.AbstractAggregator;
import net.semanticmetadata.lire.builders.AbstractLocalDocumentBuilder;
import net.semanticmetadata.lire.classifiers.Cluster;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.local.simple.SimpleExtractor;
import net.semanticmetadata.lire.indexers.parallel.ExtractorItem;

public class SimpleDocumentBuilder
extends AbstractLocalDocumentBuilder {
    public SimpleDocumentBuilder() {
    }

    public SimpleDocumentBuilder(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector keypointDetector, Cluster[] codebook) {
        this.addExtractor(globalFeatureClass, keypointDetector, codebook);
    }

    public SimpleDocumentBuilder(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector keypointDetector, LinkedList<Cluster[]> listOfCodebooks) {
        this.addExtractor(globalFeatureClass, keypointDetector, listOfCodebooks);
    }

    public SimpleDocumentBuilder(ExtractorItem extractorItem, Cluster[] codebook) {
        this.addExtractor(extractorItem, codebook);
    }

    public SimpleDocumentBuilder(ExtractorItem extractorItem, LinkedList<Cluster[]> listOfCodebooks) {
        this.addExtractor(extractorItem, listOfCodebooks);
    }

    public SimpleDocumentBuilder(Class<? extends AbstractAggregator> aggregatorClass) {
        try {
            this.aggregator = aggregatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public SimpleDocumentBuilder(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector keypointDetector, Cluster[] codebook, Class<? extends AbstractAggregator> aggregatorClass) {
        try {
            this.aggregator = aggregatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.addExtractor(globalFeatureClass, keypointDetector, codebook);
    }

    public SimpleDocumentBuilder(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector keypointDetector, LinkedList<Cluster[]> listOfCodebooks, Class<? extends AbstractAggregator> aggregatorClass) {
        try {
            this.aggregator = aggregatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.addExtractor(globalFeatureClass, keypointDetector, listOfCodebooks);
    }

    public SimpleDocumentBuilder(ExtractorItem extractorItem, Cluster[] codebook, Class<? extends AbstractAggregator> aggregatorClass) {
        try {
            this.aggregator = aggregatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.addExtractor(extractorItem, codebook);
    }

    public SimpleDocumentBuilder(ExtractorItem extractorItem, LinkedList<Cluster[]> listOfCodebooks, Class<? extends AbstractAggregator> aggregatorClass) {
        try {
            this.aggregator = aggregatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.addExtractor(extractorItem, listOfCodebooks);
    }

    public void addExtractor(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector keypointDetector, Cluster[] codebook) {
        if (codebook.length <= 0 || codebook == null) {
            throw new UnsupportedOperationException("Codebook cannot be empty or null!!");
        }
        LinkedList<Cluster[]> listOfCodebooks = new LinkedList<Cluster[]>();
        listOfCodebooks.add(codebook);
        this.addExtractor(new ExtractorItem(globalFeatureClass, keypointDetector), listOfCodebooks);
    }

    public void addExtractor(ExtractorItem extractorItem, Cluster[] codebook) {
        if (codebook.length <= 0 || codebook == null) {
            throw new UnsupportedOperationException("Codebook cannot be empty or null!!");
        }
        LinkedList<Cluster[]> listOfCodebooks = new LinkedList<Cluster[]>();
        listOfCodebooks.add(codebook);
        this.addExtractor(extractorItem, listOfCodebooks);
    }

    public void addExtractor(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector keypointDetector, LinkedList<Cluster[]> listOfCodebooks) {
        if (listOfCodebooks.size() <= 0 || listOfCodebooks == null) {
            throw new UnsupportedOperationException("List of codebooks cannot be empty or null!!");
        }
        this.addExtractor(new ExtractorItem(globalFeatureClass, keypointDetector), listOfCodebooks);
    }

    public void addExtractor(ExtractorItem extractorItem, LinkedList<Cluster[]> listOfCodebooks) {
        if (this.docsCreated) {
            throw new UnsupportedOperationException("Cannot modify builder after documents have been created!");
        }
        if (!extractorItem.isSimple()) {
            throw new UnsupportedOperationException("ExtractorItem must be SIMPLE");
        }
        if (listOfCodebooks.size() <= 0 || listOfCodebooks == null) {
            throw new UnsupportedOperationException("List of codebooks cannot be empty or null!!");
        }
        HashMap<Integer, String[]> mapOfFieldNames = new HashMap<Integer, String[]>(listOfCodebooks.size());
        String fieldName = extractorItem.getFieldName() + this.aggregator.getFieldName();
        for (Cluster[] codebook : listOfCodebooks) {
            String[] strArr = new String[]{fieldName + codebook.length, fieldName + codebook.length + "Str"};
            mapOfFieldNames.put(codebook.length, strArr);
        }
        this.extractorItems.put(extractorItem, listOfCodebooks);
        this.fieldNamesDictionary.put(extractorItem, mapOfFieldNames);
    }
}

