/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.classifiers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import net.semanticmetadata.lire.classifiers.AtomicDouble;
import net.semanticmetadata.lire.imageanalysis.features.FeatureVector;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class Cluster
implements Comparable<Object> {
    double[] mean;
    AtomicInteger size;
    AtomicDouble[] newmean;
    private double stress = 0.0;

    public Cluster() {
        this.mean = new double[128];
        Arrays.fill(this.mean, 0.0);
        this.size = new AtomicInteger(0);
        this.newmean = new AtomicDouble[this.mean.length];
        for (int i = 0; i < this.mean.length; ++i) {
            this.newmean[i] = new AtomicDouble(0.0);
        }
    }

    public Cluster(double[] mean) {
        this.mean = mean;
        this.size = new AtomicInteger(0);
        this.newmean = new AtomicDouble[mean.length];
        for (int i = 0; i < mean.length; ++i) {
            this.newmean[i] = new AtomicDouble(0.0);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        for (double next : this.mean) {
            sb.append(next);
            sb.append(';');
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Object o) {
        return ((Cluster)o).getSize() - this.getSize();
    }

    public double getDistance(FeatureVector f) {
        return this.getDistance(f.getFeatureVector());
    }

    public double getDistance(double[] f) {
        return MetricsUtils.distL2(this.mean, f);
    }

    public byte[] getByteRepresentation() {
        return SerializationUtils.toByteArray(this.mean);
    }

    public void setByteRepresentation(byte[] data) {
        this.mean = SerializationUtils.toDoubleArray(data);
    }

    public double getStress() {
        return this.stress;
    }

    public void setStress(double stress) {
        this.stress = stress;
    }

    public int getSize() {
        return this.size.get();
    }

    public void reset() {
        this.size.set(0);
        for (AtomicDouble ad : this.newmean) {
            ad.set(0.0);
        }
    }

    public void assignMember(double[] feat) {
        this.size.addAndGet(1);
        int i = 0;
        for (AtomicDouble ad : this.newmean) {
            ad.addAndGet(feat[i++]);
        }
    }

    public void move() {
        double lsize = this.size.get();
        this.stress = 0.0;
        for (int i = 0; i < this.mean.length; ++i) {
            double diff = this.mean[i] - this.newmean[i].divideAndGet(lsize);
            this.stress += lsize * diff * diff;
            this.mean[i] = this.newmean[i].get();
        }
    }

    public double[] getMean() {
        return this.mean;
    }

    public static void writeClusters(Cluster[] clusters, String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            System.out.println("File " + path + " already exists and will be overwritten!!");
        }
        FileOutputStream fout = new FileOutputStream(file);
        fout.write(SerializationUtils.toBytes(clusters.length));
        fout.write(SerializationUtils.toBytes(clusters[0].getMean().length));
        for (Cluster cluster : clusters) {
            fout.write(cluster.getByteRepresentation());
        }
        fout.close();
    }

    public static Cluster[] readClusters(String file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        byte[] tmp = new byte[4];
        fin.read(tmp, 0, 4);
        Cluster[] result = new Cluster[SerializationUtils.toInt(tmp)];
        fin.read(tmp, 0, 4);
        int size = SerializationUtils.toInt(tmp);
        tmp = new byte[size * 8];
        for (int i = 0; i < result.length; ++i) {
            int bytesRead = fin.read(tmp, 0, size * 8);
            if (bytesRead != size * 8) {
                System.err.println("Didn't read enough bytes ...");
            }
            result[i] = new Cluster();
            result[i].setByteRepresentation(tmp);
        }
        fin.close();
        return result;
    }
}

