/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.classifiers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.semanticmetadata.lire.classifiers.Cluster;
import net.semanticmetadata.lire.utils.StatsUtils;

public class KMeans {
    protected int countAllFeatures = 0;
    protected int numClusters = 512;
    protected int length;
    protected ArrayList<double[]> features = new ArrayList();
    protected Cluster[] clusters = null;

    public KMeans(int numClusters) {
        this.numClusters = numClusters;
    }

    public void addFeature(double[] feature) {
        if (!this.hasNaNs(feature)) {
            this.features.add(feature);
            ++this.countAllFeatures;
        }
    }

    public void init() {
        if (this.features.size() < this.numClusters * 2) {
            System.err.println("WARNING: Please note that the number of local features, in this case " + this.features.size() + ", is" + "smaller than the recommended minimum number, which is two times the number of visual words, in your case 2*" + this.numClusters + ". Please adapt your data and either use images with more local features or more images for creating the visual vocabulary.");
        }
        if (this.features.size() < this.numClusters + 1) {
            System.err.println("CRITICAL: The number of features is smaller than the number of clusters. This cannot work as there has to be at least one feature per cluster. Aborting process now.");
            System.out.println("features: " + this.features.size());
            System.out.println("clusters: " + this.numClusters);
            System.exit(1);
        }
        this.clusters = new Cluster[this.numClusters];
        Set<Integer> medians = this.selectInitialMedians(this.numClusters);
        assert (medians.size() == this.numClusters);
        Iterator<Integer> mediansIterator = medians.iterator();
        for (int i = 0; i < this.clusters.length; ++i) {
            double[] descriptor = this.features.get(mediansIterator.next());
            this.clusters[i] = new Cluster(new double[descriptor.length]);
            System.arraycopy(descriptor, 0, this.clusters[i].mean, 0, descriptor.length);
        }
        this.length = this.features.get(0).length;
    }

    protected Set<Integer> selectInitialMedians(int numClusters) {
        return StatsUtils.drawSample(numClusters, this.features.size());
    }

    public double clusteringStep() {
        for (Cluster cluster : this.clusters) {
            cluster.reset();
        }
        this.reOrganizeFeatures();
        this.recomputeMeans();
        return this.overallStress();
    }

    protected boolean hasNaNs(double[] histogram) {
        boolean hasNaNs = false;
        for (double next : histogram) {
            if (!Double.isNaN(next)) continue;
            hasNaNs = true;
            break;
        }
        if (hasNaNs) {
            System.err.println("Found a NaN in init");
            for (double v : histogram) {
                System.out.print(v + ", ");
            }
            System.out.println("");
        }
        return hasNaNs;
    }

    protected void reOrganizeFeatures() {
        for (int k = 0; k < this.features.size(); ++k) {
            double[] f = this.features.get(k);
            Cluster best = this.clusters[0];
            double minDistance = this.clusters[0].getDistance(f);
            for (int i = 1; i < this.clusters.length; ++i) {
                double v = this.clusters[i].getDistance(f);
                if (!(minDistance > v)) continue;
                best = this.clusters[i];
                minDistance = v;
            }
            best.assignMember(f);
        }
    }

    protected void recomputeMeans() {
        int length = this.features.get(0).length;
        for (int i = 0; i < this.clusters.length; ++i) {
            Cluster cluster = this.clusters[i];
            if (cluster.getSize() == 1) {
                System.err.println("** There is just one member in cluster " + i);
            } else if (cluster.getSize() < 1) {
                System.err.println("** There is NO member in cluster " + i);
                int index = (int)Math.floor(Math.random() * (double)this.features.size());
                this.clusters[i].assignMember(this.features.get(index));
            }
            cluster.move();
        }
    }

    protected double overallStress() {
        double v = 0.0;
        for (Cluster cluster : this.clusters) {
            v += cluster.getStress();
        }
        return v;
    }

    public int getNumClusters() {
        return this.numClusters;
    }

    public int getFeatureCount() {
        return this.countAllFeatures;
    }

    public Cluster[] getClusters() {
        return this.clusters;
    }
}

