/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.classifiers;

import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import net.semanticmetadata.lire.classifiers.Cluster;
import net.semanticmetadata.lire.classifiers.KMeans;

public class ParallelKMeans
extends KMeans {
    int numThreads = 16;
    private LinkedBlockingQueue<Item> queue = new LinkedBlockingQueue(100);

    public ParallelKMeans(int numClusters) {
        super(numClusters);
    }

    @Override
    protected void reOrganizeFeatures() {
        LinkedList<Thread> threads = new LinkedList<Thread>();
        Thread p = new Thread(new ProducerForFeatures());
        p.start();
        for (int i = 0; i < this.numThreads; ++i) {
            Thread thread = new Thread(new FeatureToClass());
            thread.start();
            threads.add(thread);
        }
        for (Thread next : threads) {
            try {
                next.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        threads.clear();
    }

    @Override
    protected void recomputeMeans() {
        LinkedList<Thread> threads = new LinkedList<Thread>();
        Thread p = new Thread(new ProducerForClusters());
        p.start();
        for (int i = 0; i < this.numThreads; ++i) {
            Thread thread = new Thread(new MeanOfCluster());
            thread.start();
            threads.add(thread);
        }
        for (Thread next : threads) {
            try {
                next.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        threads.clear();
    }

    @Override
    protected double overallStress() {
        double v = 0.0;
        LinkedList<ComputeStress> tasks = new LinkedList<ComputeStress>();
        LinkedList<Thread> threads = new LinkedList<Thread>();
        Thread p = new Thread(new ProducerForClusters());
        p.start();
        for (int i = 0; i < this.numThreads; ++i) {
            ComputeStress computeStress = new ComputeStress();
            Thread thread = new Thread(computeStress);
            thread.start();
            tasks.add(computeStress);
            threads.add(thread);
        }
        for (Thread next : threads) {
            try {
                next.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (ComputeStress task : tasks) {
            v += task.getResult();
        }
        tasks.clear();
        threads.clear();
        return v;
    }

    private class Item {
        private double[] array;
        private Cluster cluster;
        private int num;

        Item(int num, double[] array) {
            this.num = num;
            this.array = array;
        }

        Item(int num, Cluster cluster) {
            this.num = num;
            this.cluster = cluster;
        }

        private int getNum() {
            return this.num;
        }

        private Cluster getCluster() {
            return this.cluster;
        }

        private double[] getArray() {
            return this.array;
        }
    }

    class ProducerForFeatures
    implements Runnable {
        private ProducerForFeatures() {
            ParallelKMeans.this.queue.clear();
        }

        @Override
        public void run() {
            int counter = 0;
            for (double[] feature : ParallelKMeans.this.features) {
                try {
                    ParallelKMeans.this.queue.put(new Item(counter, feature));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++counter;
            }
            double[] tmp = null;
            for (int i = 0; i < ParallelKMeans.this.numThreads * 3; ++i) {
                try {
                    ParallelKMeans.this.queue.put(new Item(-1, tmp));
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class ProducerForClusters
    implements Runnable {
        private ProducerForClusters() {
            ParallelKMeans.this.queue.clear();
        }

        @Override
        public void run() {
            int counter = 0;
            for (Cluster cluster : ParallelKMeans.this.clusters) {
                try {
                    ParallelKMeans.this.queue.put(new Item(counter, cluster));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++counter;
            }
            Cluster cluster = null;
            for (int i = 0; i < ParallelKMeans.this.numThreads * 3; ++i) {
                try {
                    ParallelKMeans.this.queue.put(new Item(-1, cluster));
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class FeatureToClass
    implements Runnable {
        private boolean locallyEnded = false;

        private FeatureToClass() {
        }

        @Override
        public void run() {
            while (!this.locallyEnded) {
                try {
                    Item tmp = (Item)ParallelKMeans.this.queue.take();
                    if (tmp.getNum() == -1) {
                        this.locallyEnded = true;
                    }
                    if (this.locallyEnded) continue;
                    double[] f = tmp.getArray();
                    int best = 0;
                    double minDistance = ParallelKMeans.this.clusters[0].getDistance(f);
                    for (int i = 1; i < ParallelKMeans.this.clusters.length; ++i) {
                        double v = ParallelKMeans.this.clusters[i].getDistance(f);
                        if (!(minDistance > v)) continue;
                        best = i;
                        minDistance = v;
                    }
                    ParallelKMeans.this.clusters[best].assignMember(f);
                }
                catch (InterruptedException e) {
                    e.getMessage();
                }
            }
        }
    }

    private class MeanOfCluster
    implements Runnable {
        private boolean locallyEnded = false;

        private MeanOfCluster() {
        }

        @Override
        public void run() {
            while (!this.locallyEnded) {
                try {
                    Item tmp = (Item)ParallelKMeans.this.queue.take();
                    if (tmp.getNum() == -1) {
                        this.locallyEnded = true;
                    }
                    if (this.locallyEnded) continue;
                    Cluster cluster = tmp.getCluster();
                    if (cluster.getSize() == 1) {
                        System.err.println("** There is just one member in cluster " + tmp.getNum());
                    } else if (cluster.getSize() < 1) {
                        System.err.println("** There is NO member in cluster " + tmp.getNum());
                        cluster.assignMember((double[])ParallelKMeans.this.features.get((int)Math.floor(Math.random() * (double)ParallelKMeans.this.features.size())));
                    }
                    cluster.move();
                }
                catch (InterruptedException e) {
                    e.getMessage();
                }
            }
        }
    }

    private class ComputeStress
    implements Runnable {
        private boolean locallyEnded = false;
        double result = 0.0;

        private ComputeStress() {
        }

        @Override
        public void run() {
            while (!this.locallyEnded) {
                try {
                    Item tmp = (Item)ParallelKMeans.this.queue.take();
                    if (tmp.getNum() == -1) {
                        this.locallyEnded = true;
                    }
                    if (this.locallyEnded) continue;
                    this.result += tmp.getCluster().getStress();
                }
                catch (InterruptedException e) {
                    e.getMessage();
                }
            }
        }

        public double getResult() {
            return this.result;
        }
    }
}

