/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.filters;

import java.io.IOException;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.Logger;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.SearchHitsFilter;
import net.semanticmetadata.lire.searchers.SimpleImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleResult;
import net.semanticmetadata.lire.utils.MetricsUtils;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class LsaFilter
implements SearchHitsFilter {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Class featureClass;
    private String fieldName;
    private LireFeature tempFeature = null;
    private int numberOfDimensions = -1;

    public LsaFilter(Class featureClass, String fieldName) {
        this.featureClass = featureClass;
        this.fieldName = fieldName;
    }

    @Override
    public ImageSearchHits filter(ImageSearchHits results, IndexReader reader, Document query) {
        this.tempFeature = null;
        LinkedList<double[]> features = new LinkedList<double[]>();
        try {
            this.tempFeature = (LireFeature)this.featureClass.newInstance();
        }
        catch (Exception e) {
            this.logger.severe("Could not create feature " + this.featureClass.getName() + " (" + e.getMessage() + ").");
            return null;
        }
        for (int i = 0; i < results.length(); ++i) {
            Document d = null;
            try {
                d = reader.document(results.documentID(i));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (d.getField(this.fieldName) == null) continue;
            this.tempFeature.setByteArrayRepresentation(d.getField((String)this.fieldName).binaryValue().bytes, d.getField((String)this.fieldName).binaryValue().offset, d.getField((String)this.fieldName).binaryValue().length);
            features.add(this.tempFeature.getFeatureVector());
        }
        if (query.getField(this.fieldName) == null) {
            this.logger.severe("Query document is missing the given feature " + this.featureClass.getName() + ".");
            return null;
        }
        this.tempFeature.setByteArrayRepresentation(query.getField((String)this.fieldName).binaryValue().bytes, query.getField((String)this.fieldName).binaryValue().offset, query.getField((String)this.fieldName).binaryValue().length);
        double[][] matrixData = new double[features.size() + 1][this.tempFeature.getFeatureVector().length];
        System.arraycopy(this.tempFeature.getFeatureVector(), 0, matrixData[0], 0, this.tempFeature.getFeatureVector().length);
        int count = 1;
        for (double[] next : features) {
            System.arraycopy(next, 0, matrixData[count], 0, next.length);
            ++count;
        }
        for (int i = 0; i < matrixData.length; ++i) {
            double[] doubles = matrixData[i];
            for (int j = 0; j < doubles.length; ++j) {
                if (!Double.isNaN(doubles[j])) continue;
                System.err.println("Value is NaN");
            }
        }
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(matrixData);
        long ms = System.currentTimeMillis();
        SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)m);
        ms = System.currentTimeMillis() - ms;
        double[] singularValues = svd.getSingularValues();
        RealMatrix s = svd.getS();
        if (this.numberOfDimensions < 1) {
            this.numberOfDimensions = singularValues.length / 10;
        }
        for (int i = this.numberOfDimensions; i < singularValues.length; ++i) {
            s.setEntry(i, i, 0.0);
        }
        RealMatrix mNew = svd.getU().multiply(s).multiply(svd.getVT());
        double[][] data = mNew.getData();
        TreeSet<SimpleResult> result = new TreeSet<SimpleResult>();
        double maxDistance = 0.0;
        double[] queryData = data[0];
        for (int i = 1; i < data.length; ++i) {
            double[] doubles = data[i];
            double distance = MetricsUtils.distL1(doubles, queryData);
            result.add(new SimpleResult((float)distance, results.documentID(i - 1)));
            maxDistance = Math.max(maxDistance, distance);
        }
        SimpleImageSearchHits hits = new SimpleImageSearchHits(result, (float)maxDistance);
        return hits;
    }

    @Override
    public ImageSearchHits filter(TopDocs results, IndexReader reader, Document query) throws IOException {
        LinkedList<SimpleResult> tmp = new LinkedList<SimpleResult>();
        double max = 0.0;
        for (int i = 0; i < results.scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = results.scoreDocs[i];
            SimpleResult s = new SimpleResult(1.0f / scoreDoc.score, scoreDoc.doc);
            max = Math.max(max, (double)(1.0f / scoreDoc.score));
            tmp.add(s);
        }
        return this.filter(new SimpleImageSearchHits(tmp, (float)max), reader, query);
    }
}

