/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.filters;

import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.Logger;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.SearchHitsFilter;
import net.semanticmetadata.lire.searchers.SimpleImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleResult;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class RerankFilter
implements SearchHitsFilter {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Class featureClass;
    private String fieldName;

    public RerankFilter(Class featureClass, String fieldName) {
        this.featureClass = featureClass;
        this.fieldName = fieldName;
    }

    @Override
    public ImageSearchHits filter(ImageSearchHits results, IndexReader reader, Document query) {
        GlobalFeature queryFeature = null;
        GlobalFeature tempFeature = null;
        double distance = 0.0;
        double maxDistance = 0.0;
        TreeSet<SimpleResult> resultSet = new TreeSet<SimpleResult>();
        try {
            queryFeature = (GlobalFeature)this.featureClass.newInstance();
            tempFeature = (GlobalFeature)this.featureClass.newInstance();
        }
        catch (Exception e) {
            this.logger.severe("Could not instantiate class " + this.featureClass.getName() + " in " + this.getClass().getName() + " (" + e.getMessage() + ").");
            return null;
        }
        if (query.getField(this.fieldName) == null) {
            this.logger.severe("Given feature class " + this.featureClass.getName() + " is not available in the query document (" + this.getClass().getName() + ").");
            return null;
        }
        queryFeature.setByteArrayRepresentation(query.getField((String)this.fieldName).binaryValue().bytes, query.getField((String)this.fieldName).binaryValue().offset, query.getField((String)this.fieldName).binaryValue().length);
        for (int x = 0; x < results.length(); ++x) {
            Document d = null;
            try {
                d = reader.document(results.documentID(x));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (d.getField(this.fieldName) != null) {
                tempFeature.setByteArrayRepresentation(d.getField((String)this.fieldName).binaryValue().bytes, d.getField((String)this.fieldName).binaryValue().offset, d.getField((String)this.fieldName).binaryValue().length);
                distance = queryFeature.getDistance(tempFeature);
                maxDistance = Math.max(maxDistance, distance);
                resultSet.add(new SimpleResult(distance, results.documentID(x)));
                continue;
            }
            this.logger.info("Could not instantiate class " + this.featureClass.getName() + " from the given result set.");
        }
        return new SimpleImageSearchHits(resultSet, maxDistance);
    }

    @Override
    public ImageSearchHits filter(TopDocs results, IndexReader reader, Document query) throws IOException {
        GlobalFeature queryFeature = null;
        GlobalFeature tempFeature = null;
        double distance = 0.0;
        double maxDistance = 0.0;
        TreeSet<SimpleResult> resultSet = new TreeSet<SimpleResult>();
        try {
            queryFeature = (GlobalFeature)this.featureClass.newInstance();
            tempFeature = (GlobalFeature)this.featureClass.newInstance();
        }
        catch (Exception e) {
            this.logger.severe("Could not instantiate class " + this.featureClass.getName() + " in " + this.getClass().getName() + " (" + e.getMessage() + ").");
            return null;
        }
        if (query.getField(this.fieldName) == null) {
            this.logger.severe("Given feature class " + this.featureClass.getName() + " is not available in the query document (" + this.getClass().getName() + ").");
            return null;
        }
        queryFeature.setByteArrayRepresentation(query.getField((String)this.fieldName).binaryValue().bytes, query.getField((String)this.fieldName).binaryValue().offset, query.getField((String)this.fieldName).binaryValue().length);
        ScoreDoc[] scoreDocs = results.scoreDocs;
        Document tmp = null;
        for (int x = 0; x < scoreDocs.length; ++x) {
            tmp = reader.document(scoreDocs[x].doc);
            if (tmp.getField(this.fieldName) != null) {
                tempFeature.setByteArrayRepresentation(tmp.getField((String)this.fieldName).binaryValue().bytes, tmp.getField((String)this.fieldName).binaryValue().offset, tmp.getField((String)this.fieldName).binaryValue().length);
                distance = queryFeature.getDistance(tempFeature);
                maxDistance = Math.max(maxDistance, distance);
                resultSet.add(new SimpleResult(distance, scoreDocs[x].doc));
                continue;
            }
            this.logger.info("Could not instantiate class " + this.featureClass.getName() + " from the given result set.");
        }
        return new SimpleImageSearchHits(resultSet, maxDistance);
    }
}

