/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features;

import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class GenericByteLireFeature
implements LireFeature {
    protected byte[] data = null;
    private String featureName = "GenericByteFeature";
    private String fieldName = "featGenericByte";

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        if (this.data == null) {
            throw new UnsupportedOperationException("You need to set the histogram first.");
        }
        return this.data;
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData) {
        this.setByteArrayRepresentation(featureData, 0, featureData.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData, int offset, int length) {
        this.data = new byte[length];
        System.arraycopy(featureData, offset, this.data, 0, length);
    }

    @Override
    public double[] getFeatureVector() {
        return SerializationUtils.castToDoubleArray(this.data);
    }

    @Override
    public double getDistance(LireFeature feature) {
        if (!(feature instanceof GenericByteLireFeature)) {
            throw new UnsupportedOperationException("This is not a GenericByteLireFeature object.");
        }
        assert (((GenericByteLireFeature)feature).data.length == this.data.length);
        return MetricsUtils.distL1(((GenericByteLireFeature)feature).data, this.data);
    }

    public void setData(double[] doubleData) {
        this.data = new byte[doubleData.length];
        for (int i = 0; i < doubleData.length; ++i) {
            this.data[i] = (byte)doubleData[i];
        }
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void getFeatureName(String featureName) {
        this.featureName = featureName;
    }
}

