/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features;

import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class GenericDoubleLireFeature
implements LireFeature {
    private double[] data = null;
    private String featureName = "GenericDoubleFeature";
    private String fieldName = "featGenericDouble";

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        if (this.data == null) {
            throw new UnsupportedOperationException("You need to set the histogram first.");
        }
        return SerializationUtils.toByteArray(this.data);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData) {
        this.setByteArrayRepresentation(featureData, 0, featureData.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData, int offset, int length) {
        this.data = SerializationUtils.toDoubleArray(featureData, offset, length);
    }

    @Override
    public double[] getFeatureVector() {
        return this.data;
    }

    @Override
    public double getDistance(LireFeature feature) {
        assert (feature.getFeatureVector().length == this.data.length);
        return MetricsUtils.distL2(feature.getFeatureVector(), this.data);
    }

    public void setData(double[] data) {
        this.data = data;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void getFeatureName(String featureName) {
        this.featureName = featureName;
    }
}

