/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.global.fcth.FCTHQuant;
import net.semanticmetadata.lire.imageanalysis.features.global.fcth.Fuzzy10Bin;
import net.semanticmetadata.lire.imageanalysis.features.global.fcth.Fuzzy24Bin;
import net.semanticmetadata.lire.imageanalysis.features.global.fcth.FuzzyFCTHpart;
import net.semanticmetadata.lire.imageanalysis.features.global.fcth.RGB2HSV;
import net.semanticmetadata.lire.imageanalysis.features.global.fcth.WaveletMatrixPlus;
import net.semanticmetadata.lire.utils.ImageUtils;

public class FCTH
implements GlobalFeature {
    public boolean Compact = false;
    protected double[] histogram = new double[192];
    int tmp;
    double distResult = 0.0;
    double distTmp1 = 0.0;
    double distTmp2 = 0.0;
    double distTmpCnt1 = 0.0;
    double distTmpCnt2 = 0.0;
    double distTmpCnt3 = 0.0;

    public double[] Apply(BufferedImage image) {
        int i;
        Fuzzy10Bin Fuzzy10 = new Fuzzy10Bin(false);
        Fuzzy24Bin Fuzzy24 = new Fuzzy24Bin(false);
        FuzzyFCTHpart FuccyFCTH = new FuzzyFCTHpart();
        double[] Fuzzy10BinResultTable = new double[10];
        double[] Fuzzy24BinResultTable = new double[24];
        double[] FuzzyHistogram192 = new double[192];
        int Method2 = 2;
        int width = image.getWidth();
        int height = image.getHeight();
        for (int R = 0; R < 192; ++R) {
            FuzzyHistogram192[R] = 0.0;
        }
        RGB2HSV HSVConverter = new RGB2HSV();
        int[] HSV = new int[3];
        WaveletMatrixPlus Matrix = new WaveletMatrixPlus();
        double[][] ImageGrid = new double[width][height];
        int[][] ImageGridRed = new int[width][height];
        int[][] ImageGridGreen = new int[width][height];
        int[][] ImageGridBlue = new int[width][height];
        BufferedImage image_rgb = new BufferedImage(width, height, 4);
        image_rgb.getGraphics().drawImage(image, 0, 0, null);
        int[] pixels = ((DataBufferInt)image_rgb.getRaster().getDataBuffer()).getData();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int r;
                int pixel = pixels[y * width + x];
                int b = pixel >> 16 & 0xFF;
                int g = pixel >> 8 & 0xFF;
                ImageGridRed[x][y] = r = pixel & 0xFF;
                ImageGridGreen[x][y] = g;
                ImageGridBlue[x][y] = b;
                int mean = (int)(0.114 * (double)b + 0.587 * (double)g + 0.299 * (double)r);
                ImageGrid[x][y] = mean;
            }
        }
        int NumberOfBlocks = 1600;
        int Step_X = (int)Math.floor((double)width / Math.sqrt(NumberOfBlocks));
        int Step_Y = (int)Math.floor((double)height / Math.sqrt(NumberOfBlocks));
        if (Step_X % 2 != 0) {
            --Step_X;
        }
        if (Step_Y % 2 != 0) {
            --Step_Y;
        }
        if (Step_Y < 4) {
            Step_Y = 4;
        }
        if (Step_X < 4) {
            Step_X = 4;
        }
        for (int y = 0; y < height - Step_Y; y += Step_Y) {
            for (int x = 0; x < width - Step_X; x += Step_X) {
                int j;
                int i2;
                double[][] Block = new double[4][4];
                int[][] BlockR = new int[4][4];
                int[][] BlockG = new int[4][4];
                int[][] BlockB = new int[4][4];
                int[][] BlockCount = new int[4][4];
                int[] CororRed = new int[Step_Y * Step_X];
                int[] CororGreen = new int[Step_Y * Step_X];
                int[] CororBlue = new int[Step_Y * Step_X];
                int[] CororRedTemp = new int[Step_Y * Step_X];
                int[] CororGreenTemp = new int[Step_Y * Step_X];
                int[] CororBlueTemp = new int[Step_Y * Step_X];
                int MeanRed = 0;
                int MeanGreen = 0;
                int MeanBlue = 0;
                int CurrentPixelX = 0;
                int CurrentPixelY = 0;
                for (int i3 = 0; i3 < 4; ++i3) {
                    for (int j2 = 0; j2 < 4; ++j2) {
                        Block[i3][j2] = 0.0;
                        BlockCount[i3][j2] = 0;
                    }
                }
                int TempSum = 0;
                for (i2 = 0; i2 < Step_X; ++i2) {
                    for (j = 0; j < Step_Y; ++j) {
                        CurrentPixelX = 0;
                        CurrentPixelY = 0;
                        if (i2 >= Step_X / 4) {
                            CurrentPixelX = 1;
                        }
                        if (i2 >= Step_X / 2) {
                            CurrentPixelX = 2;
                        }
                        if (i2 >= 3 * Step_X / 4) {
                            CurrentPixelX = 3;
                        }
                        if (j >= Step_Y / 4) {
                            CurrentPixelY = 1;
                        }
                        if (j >= Step_Y / 2) {
                            CurrentPixelY = 2;
                        }
                        if (j >= 3 * Step_Y / 4) {
                            CurrentPixelY = 3;
                        }
                        double[] dArray = Block[CurrentPixelX];
                        int n = CurrentPixelY;
                        dArray[n] = dArray[n] + ImageGrid[x + i2][y + j];
                        int[] nArray = BlockCount[CurrentPixelX];
                        int n2 = CurrentPixelY;
                        nArray[n2] = nArray[n2] + 1;
                        BlockR[CurrentPixelX][CurrentPixelY] = ImageGridRed[x + i2][y + j];
                        BlockG[CurrentPixelX][CurrentPixelY] = ImageGridGreen[x + i2][y + j];
                        BlockB[CurrentPixelX][CurrentPixelY] = ImageGridBlue[x + i2][y + j];
                        CororRed[TempSum] = BlockR[CurrentPixelX][CurrentPixelY];
                        CororGreen[TempSum] = BlockG[CurrentPixelX][CurrentPixelY];
                        CororBlue[TempSum] = BlockB[CurrentPixelX][CurrentPixelY];
                        CororRedTemp[TempSum] = BlockR[CurrentPixelX][CurrentPixelY];
                        CororGreenTemp[TempSum] = BlockG[CurrentPixelX][CurrentPixelY];
                        CororBlueTemp[TempSum] = BlockB[CurrentPixelX][CurrentPixelY];
                        ++TempSum;
                    }
                }
                for (i2 = 0; i2 < 4; ++i2) {
                    for (j = 0; j < 4; ++j) {
                        Block[i2][j] = Block[i2][j] / (double)BlockCount[i2][j];
                    }
                }
                Matrix = this.singlePassThreshold(Block, 1);
                for (i2 = 0; i2 < Step_Y * Step_X; ++i2) {
                    MeanRed += CororRed[i2];
                    MeanGreen += CororGreen[i2];
                    MeanBlue += CororBlue[i2];
                }
                HSV = HSVConverter.ApplyFilter(MeanRed /= Step_Y * Step_X, MeanGreen /= Step_Y * Step_X, MeanBlue /= Step_Y * Step_X);
                if (!this.Compact) {
                    Fuzzy10BinResultTable = Fuzzy10.ApplyFilter(HSV[0], HSV[1], HSV[2], Method2);
                    Fuzzy24BinResultTable = Fuzzy24.ApplyFilter(HSV[0], HSV[1], HSV[2], Fuzzy10BinResultTable, Method2);
                    FuzzyHistogram192 = FuccyFCTH.ApplyFilter(Matrix.F3, Matrix.F2, Matrix.F1, Fuzzy24BinResultTable, Method2, 24);
                    continue;
                }
                Fuzzy10BinResultTable = Fuzzy10.ApplyFilter(HSV[0], HSV[1], HSV[2], Method2);
                FuzzyHistogram192 = FuccyFCTH.ApplyFilter(Matrix.F3, Matrix.F2, Matrix.F1, Fuzzy10BinResultTable, Method2, 10);
            }
        }
        double TotalSum = 0.0;
        for (i = 0; i < 192; ++i) {
            TotalSum += FuzzyHistogram192[i];
        }
        for (i = 0; i < 192; ++i) {
            FuzzyHistogram192[i] = FuzzyHistogram192[i] / TotalSum;
        }
        FCTHQuant Quant = new FCTHQuant();
        FuzzyHistogram192 = Quant.Apply(FuzzyHistogram192);
        return FuzzyHistogram192;
    }

    private WaveletMatrixPlus singlePassThreshold(double[][] inputMatrix, int level) {
        WaveletMatrixPlus TempMatrix = new WaveletMatrixPlus();
        level = (int)Math.pow(2.0, level - 1);
        double[][] resultMatrix = new double[inputMatrix.length][inputMatrix[0].length];
        int xOffset = inputMatrix.length / 2 / level;
        int yOffset = inputMatrix[0].length / 2 / level;
        int currentPixel = 0;
        double multiplier = 0.0;
        for (int y = 0; y < inputMatrix[0].length; ++y) {
            for (int x = 0; x < inputMatrix.length; ++x) {
                if (y < inputMatrix[0].length / 2 / level && x < inputMatrix.length / 2 / level) {
                    ++currentPixel;
                    resultMatrix[x][y] = (inputMatrix[2 * x][2 * y] + inputMatrix[2 * x + 1][2 * y] + inputMatrix[2 * x][2 * y + 1] + inputMatrix[2 * x + 1][2 * y + 1]) / 4.0;
                    double vertDiff = -inputMatrix[2 * x][2 * y] - inputMatrix[2 * x + 1][2 * y] + inputMatrix[2 * x][2 * y + 1] + inputMatrix[2 * x + 1][2 * y + 1];
                    double horzDiff = inputMatrix[2 * x][2 * y] - inputMatrix[2 * x + 1][2 * y] + inputMatrix[2 * x][2 * y + 1] - inputMatrix[2 * x + 1][2 * y + 1];
                    double diagDiff = -inputMatrix[2 * x][2 * y] + inputMatrix[2 * x + 1][2 * y] + inputMatrix[2 * x][2 * y + 1] - inputMatrix[2 * x + 1][2 * y + 1];
                    resultMatrix[x + xOffset][y] = (byte)(multiplier + Math.abs(vertDiff));
                    resultMatrix[x][y + yOffset] = (byte)(multiplier + Math.abs(horzDiff));
                    resultMatrix[x + xOffset][y + yOffset] = (byte)(multiplier + Math.abs(diagDiff));
                    continue;
                }
                if (x < inputMatrix.length / level && y < inputMatrix[0].length / level) continue;
                resultMatrix[x][y] = inputMatrix[x][y];
            }
        }
        double Temp1 = 0.0;
        double Temp2 = 0.0;
        double Temp3 = 0.0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                Temp1 += 0.25 * Math.pow(resultMatrix[2 + i][j], 2.0);
                Temp2 += 0.25 * Math.pow(resultMatrix[i][2 + j], 2.0);
                Temp3 += 0.25 * Math.pow(resultMatrix[2 + i][2 + j], 2.0);
            }
        }
        TempMatrix.F1 = Math.sqrt(Temp1);
        TempMatrix.F2 = Math.sqrt(Temp2);
        TempMatrix.F3 = Math.sqrt(Temp3);
        TempMatrix.Entropy = 0.0;
        return TempMatrix;
    }

    @Override
    public void extract(BufferedImage bimg) {
        bimg = ImageUtils.get8BitRGBImage(bimg);
        this.histogram = this.Apply(bimg);
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        int position = -1;
        for (int i = 0; i < this.histogram.length; ++i) {
            if (position == -1) {
                if (this.histogram[i] != 0.0) continue;
                position = i;
                continue;
            }
            if (position <= -1 || this.histogram[i] == 0.0) continue;
            position = -1;
        }
        if (position < 0) {
            position = this.histogram.length - 1;
        }
        int length = (position + 1) / 2;
        if ((position + 1) % 2 == 1) {
            length = position / 2 + 1;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < result.length; ++i) {
            this.tmp = (int)(this.histogram[i << 1] * 2.0) << 4;
            this.tmp |= (int)(this.histogram[(i << 1) + 1] * 2.0);
            result[i] = (byte)(this.tmp - 128);
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        if (length << 1 < this.histogram.length) {
            Arrays.fill(this.histogram, length << 1, this.histogram.length, 0.0);
        }
        for (int i = offset; i < offset + length; ++i) {
            this.tmp = in[i] + 128;
            this.histogram[(i - offset << 1) + 1] = (double)(this.tmp & 0xF) / 2.0;
            this.histogram[i - offset << 1] = (double)(this.tmp >> 4) / 2.0;
        }
    }

    @Override
    public double[] getFeatureVector() {
        return this.histogram;
    }

    @Override
    public double getDistance(LireFeature vd) {
        int i;
        if (!(vd instanceof FCTH)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        FCTH ch = (FCTH)vd;
        if (ch.histogram.length != this.histogram.length) {
            throw new UnsupportedOperationException("Histogram lengths or color spaces do not match");
        }
        this.distResult = 0.0;
        this.distTmp1 = 0.0;
        this.distTmp2 = 0.0;
        this.distTmpCnt1 = 0.0;
        this.distTmpCnt2 = 0.0;
        this.distTmpCnt3 = 0.0;
        for (i = 0; i < ch.histogram.length; ++i) {
            this.distTmp1 += ch.histogram[i];
            this.distTmp2 += this.histogram[i];
        }
        if (this.distTmp1 == 0.0 && this.distTmp2 == 0.0) {
            return 0.0;
        }
        if (this.distTmp1 == 0.0 || this.distTmp2 == 0.0) {
            return 100.0;
        }
        for (i = 0; i < ch.histogram.length; ++i) {
            this.distTmpCnt1 += ch.histogram[i] / this.distTmp1 * (this.histogram[i] / this.distTmp2);
            this.distTmpCnt2 += this.histogram[i] / this.distTmp2 * (this.histogram[i] / this.distTmp2);
            this.distTmpCnt3 += ch.histogram[i] / this.distTmp1 * (ch.histogram[i] / this.distTmp1);
        }
        this.distResult = 100.0 - 100.0 * (this.distTmpCnt1 / (this.distTmpCnt2 + this.distTmpCnt3 - this.distTmpCnt1));
        return this.distResult;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.histogram.length * 2 + 25);
        for (double aData : this.histogram) {
            sb.append((int)aData);
            sb.append(' ');
        }
        return "FCTH{" + sb.toString().trim() + "}";
    }

    @Override
    public String getFeatureName() {
        return "FCTH";
    }

    @Override
    public String getFieldName() {
        return "FCTH";
    }
}

